/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.utils;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;

public class PixMapHelper {
    public static Pixmap fromTextureRegion(TextureAtlas.AtlasRegion region, int scale) {
        Texture texture = region.getTexture();
        TextureData textureData = texture.getTextureData();
        if (!textureData.isPrepared()) {
            textureData.prepare();
        }
        Pixmap texturePixmap = textureData.consumePixmap();
        Pixmap ret = new Pixmap(region.getRegionWidth() * scale, region.getRegionHeight() * scale, texturePixmap.getFormat());
        int srcX = region.getRegionX();
        int srcY = region.getRegionY();
        int srcWidth = region.getRegionWidth();
        int srcHeight = region.getRegionHeight();
        if (region.isFlipY()) {
            ret.drawPixmap(texturePixmap, srcX, srcY + srcHeight, srcWidth + 1, -srcHeight - 1, 0, 0, ret.getWidth(), ret.getHeight());
        } else {
            ret.drawPixmap(texturePixmap, srcX, srcY, srcWidth + 1, srcHeight + 1, 0, 0, ret.getWidth(), ret.getHeight());
        }
        return ret;
    }
}

