/*
 * Decompiled with CFR 0.152.
 */
package io.github.orioncraftmc.meditate;

import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import io.github.orioncraftmc.meditate.YogaConfig;
import io.github.orioncraftmc.meditate.YogaConfigWrapper;
import io.github.orioncraftmc.meditate.YogaNode;
import io.github.orioncraftmc.meditate.YogaValue;
import io.github.orioncraftmc.meditate.enums.YogaAlign;
import io.github.orioncraftmc.meditate.enums.YogaDirection;
import io.github.orioncraftmc.meditate.enums.YogaDisplay;
import io.github.orioncraftmc.meditate.enums.YogaEdge;
import io.github.orioncraftmc.meditate.enums.YogaFlexDirection;
import io.github.orioncraftmc.meditate.enums.YogaJustify;
import io.github.orioncraftmc.meditate.enums.YogaMeasureMode;
import io.github.orioncraftmc.meditate.enums.YogaOverflow;
import io.github.orioncraftmc.meditate.enums.YogaPositionType;
import io.github.orioncraftmc.meditate.enums.YogaUnit;
import io.github.orioncraftmc.meditate.enums.YogaWrap;
import io.github.orioncraftmc.meditate.interfaces.YogaBaselineFunction;
import io.github.orioncraftmc.meditate.interfaces.YogaMeasureFunction;
import io.github.orioncraftmc.meditate.internal.GlobalMembers;
import io.github.orioncraftmc.meditate.internal.YGNode;
import io.github.orioncraftmc.meditate.internal.YGSize;
import io.github.orioncraftmc.meditate.internal.YGValue;
import io.github.orioncraftmc.meditate.internal.enums.YGAlign;
import io.github.orioncraftmc.meditate.internal.enums.YGDirection;
import io.github.orioncraftmc.meditate.internal.enums.YGDisplay;
import io.github.orioncraftmc.meditate.internal.enums.YGEdge;
import io.github.orioncraftmc.meditate.internal.enums.YGFlexDirection;
import io.github.orioncraftmc.meditate.internal.enums.YGJustify;
import io.github.orioncraftmc.meditate.internal.enums.YGOverflow;
import io.github.orioncraftmc.meditate.internal.enums.YGPositionType;
import io.github.orioncraftmc.meditate.internal.enums.YGWrap;
import java.util.ArrayList;
import java.util.List;

public class YogaNodeWrapper
extends YogaNode {
    private static final byte MARGIN = 1;
    private static final byte PADDING = 2;
    private static final byte BORDER = 4;
    private static final byte DOES_LEGACY_STRETCH_BEHAVIOUR = 8;
    private static final byte HAS_NEW_LAYOUT = 16;
    private static final byte LAYOUT_EDGE_SET_FLAG_INDEX = 0;
    private static final byte LAYOUT_WIDTH_INDEX = 1;
    private static final byte LAYOUT_HEIGHT_INDEX = 2;
    private static final byte LAYOUT_LEFT_INDEX = 3;
    private static final byte LAYOUT_TOP_INDEX = 4;
    private static final byte LAYOUT_DIRECTION_INDEX = 5;
    private static final byte LAYOUT_MARGIN_START_INDEX = 6;
    private static final byte LAYOUT_PADDING_START_INDEX = 10;
    private static final byte LAYOUT_BORDER_START_INDEX = 14;
    protected YGNode mNativePointer;
    private YogaNodeWrapper mOwner;
    private List<YogaNodeWrapper> mChildren;
    private YogaMeasureFunction mMeasureFunction;
    private YogaBaselineFunction mBaselineFunction;
    private Object mData;
    private int mLayoutDirection = 0;
    public boolean minWidthManuallySet;
    public boolean minHeightManuallySet;
    private Drawable background;

    private YogaNodeWrapper(YGNode nativePointer) {
        this.mNativePointer = nativePointer;
    }

    YogaNodeWrapper() {
        this(GlobalMembers.YGNodeNew());
    }

    YogaNodeWrapper(YogaConfig config) {
        this(GlobalMembers.YGNodeNewWithConfig(((YogaConfigWrapper)config).mNativePointer));
    }

    private static YogaValue valueFromNative(YGValue value) {
        return new YogaValue(value.getValue(), YogaUnit.fromInt(value.getUnit().getValue()));
    }

    @Override
    public void reset() {
        this.mMeasureFunction = null;
        this.mBaselineFunction = null;
        this.mData = null;
        GlobalMembers.YGNodeReset(this.mNativePointer);
    }

    @Override
    public int getChildCount() {
        return this.mChildren == null ? 0 : this.mChildren.size();
    }

    @Override
    public YogaNodeWrapper getChildAt(int i) {
        if (this.mChildren == null) {
            throw new IllegalStateException("YogaNode does not have children");
        }
        return this.mChildren.get(i);
    }

    @Override
    public void addChildAt(YogaNode c, int i) {
        if (!(c instanceof YogaNodeWrapper)) {
            return;
        }
        YogaNodeWrapper child = (YogaNodeWrapper)c;
        if (child.mOwner != null) {
            throw new IllegalStateException("Child already has a parent, it must be removed first.");
        }
        if (this.mChildren == null) {
            this.mChildren = new ArrayList<YogaNodeWrapper>(4);
        }
        this.mChildren.add(i, child);
        child.mOwner = this;
        GlobalMembers.YGNodeInsertChild(this.mNativePointer, child.mNativePointer, i);
    }

    @Override
    public YogaNode setIsReferenceBaseline(boolean isReferenceBaseline) {
        GlobalMembers.YGNodeSetIsReferenceBaseline(this.mNativePointer, isReferenceBaseline);
        return this;
    }

    @Override
    public boolean isReferenceBaseline() {
        return GlobalMembers.YGNodeIsReferenceBaseline(this.mNativePointer);
    }

    public void swapChildAt(YogaNode newChild, int position) {
        if (!(newChild instanceof YogaNodeWrapper)) {
            return;
        }
        YogaNodeWrapper child = (YogaNodeWrapper)newChild;
        this.mChildren.remove(position);
        this.mChildren.add(position, child);
        child.mOwner = this;
        GlobalMembers.YGNodeSwapChild(this.mNativePointer, child.mNativePointer, position);
    }

    private YogaNodeWrapper cloneShallow() {
        YogaNodeWrapper clone = new YogaNodeWrapper();
        clone.mNativePointer = this.mNativePointer;
        clone.mOwner = this.mOwner;
        clone.mChildren = this.mChildren;
        clone.mMeasureFunction = this.mMeasureFunction;
        clone.mBaselineFunction = this.mBaselineFunction;
        clone.mData = this.mData;
        clone.mLayoutDirection = this.mLayoutDirection;
        return clone;
    }

    @Override
    public YogaNodeWrapper cloneWithChildren() {
        YogaNodeWrapper clonedYogaNode = this.cloneShallow();
        if (clonedYogaNode.mChildren != null) {
            clonedYogaNode.mChildren = new ArrayList<YogaNodeWrapper>(clonedYogaNode.mChildren);
        }
        YGNode clonedNativePointer = GlobalMembers.YGNodeClone(this.mNativePointer);
        clonedYogaNode.mOwner = null;
        clonedYogaNode.mNativePointer = clonedNativePointer;
        for (int i = 0; i < clonedYogaNode.getChildCount(); ++i) {
            clonedYogaNode.swapChildAt(clonedYogaNode.getChildAt(i).cloneWithChildren(), i);
        }
        return clonedYogaNode;
    }

    @Override
    public YogaNodeWrapper cloneWithoutChildren() {
        YogaNodeWrapper clonedYogaNode = this.cloneShallow();
        YGNode clonedNativePointer = GlobalMembers.YGNodeClone(this.mNativePointer);
        clonedYogaNode.mOwner = null;
        clonedYogaNode.mNativePointer = clonedNativePointer;
        clonedYogaNode.clearChildren();
        return clonedYogaNode;
    }

    private void clearChildren() {
        this.mChildren = null;
        this.mNativePointer.clearChildren();
    }

    @Override
    public YogaNodeWrapper removeChildAt(int i) {
        if (this.mChildren == null) {
            throw new IllegalStateException("Trying to remove a child of a YogaNode that does not have children");
        }
        YogaNodeWrapper child = this.mChildren.remove(i);
        child.mOwner = null;
        GlobalMembers.YGNodeRemoveChild(this.mNativePointer, child.mNativePointer);
        return child;
    }

    @Override
    public YogaNodeWrapper getOwner() {
        return this.mOwner;
    }

    @Override
    @Deprecated
    public YogaNodeWrapper getParent() {
        return this.getOwner();
    }

    @Override
    public int indexOf(YogaNode child) {
        return this.mChildren == null ? -1 : this.mChildren.indexOf(child);
    }

    @Override
    public void calculateLayout(float width, float height) {
        int i;
        YGNode[] nativePointers = null;
        YogaNodeWrapper[] nodes = null;
        this.freeze(null);
        ArrayList<YogaNodeWrapper> n = new ArrayList<YogaNodeWrapper>();
        n.add(this);
        for (i = 0; i < n.size(); ++i) {
            YogaNodeWrapper parent = (YogaNodeWrapper)n.get(i);
            List<YogaNodeWrapper> children = parent.mChildren;
            if (children == null) continue;
            for (YogaNodeWrapper child : children) {
                child.freeze(parent);
                n.add(child);
            }
        }
        nodes = n.toArray(new YogaNodeWrapper[0]);
        nativePointers = new YGNode[nodes.length];
        for (i = 0; i < nodes.length; ++i) {
            nativePointers[i] = nodes[i].mNativePointer;
        }
        GlobalMembers.YGNodeCalculateLayoutWithContext(this.mNativePointer, width, height, GlobalMembers.YGNodeStyleGetDirection(this.mNativePointer), nativePointers);
    }

    private void freeze(YogaNode parent) {
        Object data = this.getData();
        if (data instanceof YogaNode.Inputs) {
            ((YogaNode.Inputs)data).freeze(this, parent);
        }
    }

    @Override
    public void dirty() {
        GlobalMembers.YGNodeMarkDirty(this.mNativePointer);
    }

    public void dirtyAllDescendants() {
        GlobalMembers.YGNodeMarkDirtyAndPropogateToDescendants(this.mNativePointer);
    }

    @Override
    public boolean isDirty() {
        return GlobalMembers.YGNodeIsDirty(this.mNativePointer);
    }

    @Override
    public void copyStyle(YogaNode srcNode) {
        if (!(srcNode instanceof YogaNodeWrapper)) {
            return;
        }
        GlobalMembers.YGNodeCopyStyle(this.mNativePointer, ((YogaNodeWrapper)srcNode).mNativePointer);
    }

    @Override
    public YogaDirection getStyleDirection() {
        return YogaDirection.fromInt(GlobalMembers.YGNodeStyleGetDirection(this.mNativePointer).getValue());
    }

    @Override
    public YogaNode setDirection(YogaDirection direction) {
        GlobalMembers.YGNodeStyleSetDirection(this.mNativePointer, YGDirection.forValue(direction.intValue()));
        return this;
    }

    @Override
    public YogaFlexDirection getFlexDirection() {
        return YogaFlexDirection.fromInt(GlobalMembers.YGNodeStyleGetFlexDirection(this.mNativePointer).getValue());
    }

    @Override
    public YogaNode setFlexDirection(YogaFlexDirection flexDirection) {
        GlobalMembers.YGNodeStyleSetFlexDirection(this.mNativePointer, YGFlexDirection.forValue(flexDirection.intValue()));
        return this;
    }

    @Override
    public YogaJustify getJustifyContent() {
        return YogaJustify.fromInt(GlobalMembers.YGNodeStyleGetJustifyContent(this.mNativePointer).getValue());
    }

    @Override
    public YogaNode setJustifyContent(YogaJustify justifyContent) {
        GlobalMembers.YGNodeStyleSetJustifyContent(this.mNativePointer, YGJustify.forValue(justifyContent.intValue()));
        return this;
    }

    @Override
    public YogaAlign getAlignItems() {
        return YogaAlign.fromInt(GlobalMembers.YGNodeStyleGetAlignItems(this.mNativePointer).getValue());
    }

    @Override
    public YogaNode setAlignItems(YogaAlign alignItems) {
        GlobalMembers.YGNodeStyleSetAlignItems(this.mNativePointer, YGAlign.forValue(alignItems.intValue()));
        return this;
    }

    @Override
    public YogaAlign getAlignSelf() {
        return YogaAlign.fromInt(GlobalMembers.YGNodeStyleGetAlignSelf(this.mNativePointer).getValue());
    }

    @Override
    public YogaNode setAlignSelf(YogaAlign alignSelf) {
        GlobalMembers.YGNodeStyleSetAlignSelf(this.mNativePointer, YGAlign.forValue(alignSelf.intValue()));
        return this;
    }

    @Override
    public YogaAlign getAlignContent() {
        return YogaAlign.fromInt(GlobalMembers.YGNodeStyleGetAlignContent(this.mNativePointer).getValue());
    }

    @Override
    public YogaNode setAlignContent(YogaAlign alignContent) {
        GlobalMembers.YGNodeStyleSetAlignContent(this.mNativePointer, YGAlign.forValue(alignContent.intValue()));
        return this;
    }

    @Override
    public YogaPositionType getPositionType() {
        return YogaPositionType.fromInt(GlobalMembers.YGNodeStyleGetPositionType(this.mNativePointer).getValue());
    }

    @Override
    public YogaNode setPositionType(YogaPositionType positionType) {
        GlobalMembers.YGNodeStyleSetPositionType(this.mNativePointer, YGPositionType.forValue(positionType.intValue()));
        return this;
    }

    @Override
    public YogaWrap getWrap() {
        return YogaWrap.fromInt(GlobalMembers.YGNodeStyleGetFlexWrap(this.mNativePointer).getValue());
    }

    @Override
    public YogaNode setWrap(YogaWrap flexWrap) {
        GlobalMembers.YGNodeStyleSetFlexWrap(this.mNativePointer, YGWrap.forValue(flexWrap.intValue()));
        return this;
    }

    @Override
    public YogaOverflow getOverflow() {
        return YogaOverflow.fromInt(GlobalMembers.YGNodeStyleGetOverflow(this.mNativePointer).getValue());
    }

    @Override
    public YogaNode setOverflow(YogaOverflow overflow) {
        GlobalMembers.YGNodeStyleSetOverflow(this.mNativePointer, YGOverflow.forValue(overflow.intValue()));
        return this;
    }

    @Override
    public YogaDisplay getDisplay() {
        return YogaDisplay.fromInt(GlobalMembers.YGNodeStyleGetDisplay(this.mNativePointer).getValue());
    }

    @Override
    public YogaNode setDisplay(YogaDisplay display) {
        GlobalMembers.YGNodeStyleSetDisplay(this.mNativePointer, YGDisplay.forValue(display.intValue()));
        return this;
    }

    @Override
    public float getFlex() {
        return GlobalMembers.YGNodeStyleGetFlex(this.mNativePointer);
    }

    @Override
    public YogaNode setFlex(float flex) {
        GlobalMembers.YGNodeStyleSetFlex(this.mNativePointer, flex);
        return this;
    }

    @Override
    public float getFlexGrow() {
        return GlobalMembers.YGNodeStyleGetFlexGrow(this.mNativePointer);
    }

    @Override
    public YogaNode setFlexGrow(float flexGrow) {
        GlobalMembers.YGNodeStyleSetFlexGrow(this.mNativePointer, flexGrow);
        return this;
    }

    @Override
    public float getFlexShrink() {
        return GlobalMembers.YGNodeStyleGetFlexShrink(this.mNativePointer);
    }

    @Override
    public YogaNode setFlexShrink(float flexShrink) {
        GlobalMembers.YGNodeStyleSetFlexShrink(this.mNativePointer, flexShrink);
        return this;
    }

    @Override
    public YogaValue getFlexBasis() {
        return YogaNodeWrapper.valueFromNative(GlobalMembers.YGNodeStyleGetFlexBasis(this.mNativePointer));
    }

    @Override
    public YogaNode setFlexBasis(float flexBasis) {
        GlobalMembers.YGNodeStyleSetFlexBasis(this.mNativePointer, flexBasis);
        return this;
    }

    @Override
    public YogaNode setFlexBasisPercent(float percent) {
        GlobalMembers.YGNodeStyleSetFlexBasisPercent(this.mNativePointer, percent);
        return this;
    }

    @Override
    public YogaNode setFlexBasisAuto() {
        GlobalMembers.YGNodeStyleSetFlexBasisAuto(this.mNativePointer);
        return this;
    }

    @Override
    public YogaValue getMargin(YogaEdge edge) {
        return YogaNodeWrapper.valueFromNative(GlobalMembers.YGNodeStyleGetMargin(this.mNativePointer, YGEdge.forValue(edge.intValue())));
    }

    @Override
    public YogaNode setMargin(YogaEdge edge, float margin) {
        GlobalMembers.YGNodeStyleSetMargin(this.mNativePointer, YGEdge.forValue(edge.intValue()), margin);
        return this;
    }

    @Override
    public YogaNode setMarginPercent(YogaEdge edge, float percent) {
        GlobalMembers.YGNodeStyleSetMarginPercent(this.mNativePointer, YGEdge.forValue(edge.intValue()), percent);
        return this;
    }

    @Override
    public YogaNode setMarginAuto(YogaEdge edge) {
        GlobalMembers.YGNodeStyleSetMarginAuto(this.mNativePointer, YGEdge.forValue(edge.intValue()));
        return this;
    }

    @Override
    public YogaValue getPadding(YogaEdge edge) {
        return YogaNodeWrapper.valueFromNative(GlobalMembers.YGNodeStyleGetPadding(this.mNativePointer, YGEdge.forValue(edge.intValue())));
    }

    @Override
    public YogaNode setPadding(YogaEdge edge, float padding) {
        GlobalMembers.YGNodeStyleSetPadding(this.mNativePointer, YGEdge.forValue(edge.intValue()), padding);
        return this;
    }

    @Override
    public YogaNode setPaddingPercent(YogaEdge edge, float percent) {
        GlobalMembers.YGNodeStyleSetPaddingPercent(this.mNativePointer, YGEdge.forValue(edge.intValue()), percent);
        return this;
    }

    @Override
    public float getBorder(YogaEdge edge) {
        return GlobalMembers.YGNodeStyleGetBorder(this.mNativePointer, YGEdge.forValue(edge.intValue()));
    }

    @Override
    public YogaNode setBorder(YogaEdge edge, float border) {
        GlobalMembers.YGNodeStyleSetBorder(this.mNativePointer, YGEdge.forValue(edge.intValue()), border);
        return this;
    }

    @Override
    public YogaValue getPosition(YogaEdge edge) {
        return YogaNodeWrapper.valueFromNative(GlobalMembers.YGNodeStyleGetPosition(this.mNativePointer, YGEdge.forValue(edge.intValue())));
    }

    @Override
    public YogaNode setPosition(YogaEdge edge, float position) {
        GlobalMembers.YGNodeStyleSetPosition(this.mNativePointer, YGEdge.forValue(edge.intValue()), position);
        return this;
    }

    @Override
    public YogaNode setPositionPercent(YogaEdge edge, float percent) {
        GlobalMembers.YGNodeStyleSetPositionPercent(this.mNativePointer, YGEdge.forValue(edge.intValue()), percent);
        return this;
    }

    @Override
    public YogaValue getWidth() {
        return YogaNodeWrapper.valueFromNative(GlobalMembers.YGNodeStyleGetWidth(this.mNativePointer));
    }

    @Override
    public YogaNode setWidth(float width) {
        GlobalMembers.YGNodeStyleSetWidth(this.mNativePointer, width);
        return this;
    }

    @Override
    public YogaNode setWidthPercent(float percent) {
        GlobalMembers.YGNodeStyleSetWidthPercent(this.mNativePointer, percent);
        return this;
    }

    @Override
    public YogaNode setWidthAuto() {
        GlobalMembers.YGNodeStyleSetWidthAuto(this.mNativePointer);
        return this;
    }

    @Override
    public YogaValue getHeight() {
        return YogaNodeWrapper.valueFromNative(GlobalMembers.YGNodeStyleGetHeight(this.mNativePointer));
    }

    @Override
    public YogaNode setHeight(float height) {
        GlobalMembers.YGNodeStyleSetHeight(this.mNativePointer, height);
        return this;
    }

    @Override
    public YogaNode setHeightPercent(float percent) {
        GlobalMembers.YGNodeStyleSetHeightPercent(this.mNativePointer, percent);
        return this;
    }

    @Override
    public YogaNode setHeightAuto() {
        GlobalMembers.YGNodeStyleSetHeightAuto(this.mNativePointer);
        return this;
    }

    @Override
    public YogaValue getMinWidth() {
        return YogaNodeWrapper.valueFromNative(GlobalMembers.YGNodeStyleGetMinWidth(this.mNativePointer));
    }

    @Override
    public YogaNode setMinWidth(float minWidth) {
        this.minWidthManuallySet = true;
        GlobalMembers.YGNodeStyleSetMinWidth(this.mNativePointer, minWidth);
        return this;
    }

    @Override
    public YogaNode setMinWidthPercent(float percent) {
        this.minWidthManuallySet = true;
        GlobalMembers.YGNodeStyleSetMinWidthPercent(this.mNativePointer, percent);
        return this;
    }

    @Override
    public YogaValue getMinHeight() {
        return YogaNodeWrapper.valueFromNative(GlobalMembers.YGNodeStyleGetMinHeight(this.mNativePointer));
    }

    @Override
    public YogaNode setMinHeight(float minHeight) {
        this.minHeightManuallySet = true;
        GlobalMembers.YGNodeStyleSetMinHeight(this.mNativePointer, minHeight);
        return this;
    }

    @Override
    public YogaNode setMinHeightPercent(float percent) {
        this.minHeightManuallySet = true;
        GlobalMembers.YGNodeStyleSetMinHeightPercent(this.mNativePointer, percent);
        return this;
    }

    @Override
    public YogaValue getMaxWidth() {
        return YogaNodeWrapper.valueFromNative(GlobalMembers.YGNodeStyleGetMaxWidth(this.mNativePointer));
    }

    @Override
    public YogaNode setMaxWidth(float maxWidth) {
        GlobalMembers.YGNodeStyleSetMaxWidth(this.mNativePointer, maxWidth);
        return this;
    }

    @Override
    public YogaNode setMaxWidthPercent(float percent) {
        GlobalMembers.YGNodeStyleSetMaxWidthPercent(this.mNativePointer, percent);
        return this;
    }

    @Override
    public YogaValue getMaxHeight() {
        return YogaNodeWrapper.valueFromNative(GlobalMembers.YGNodeStyleGetMaxHeight(this.mNativePointer));
    }

    @Override
    public YogaNode setMaxHeight(float maxheight) {
        GlobalMembers.YGNodeStyleSetMaxHeight(this.mNativePointer, maxheight);
        return this;
    }

    @Override
    public YogaNode setMaxHeightPercent(float percent) {
        GlobalMembers.YGNodeStyleSetMaxHeightPercent(this.mNativePointer, percent);
        return this;
    }

    @Override
    public YogaNode setSize(float size) {
        this.setWidth(size);
        this.setHeight(size);
        return this;
    }

    @Override
    public YogaNode setSizePercent(float percent) {
        this.setWidthPercent(percent);
        this.setHeightPercent(percent);
        return this;
    }

    @Override
    public YogaNode setMinSize(float minSize) {
        this.setMinWidth(minSize);
        this.setMinHeight(minSize);
        return this;
    }

    @Override
    public YogaNode setMinSizePercent(float minSizePercent) {
        this.setMinWidthPercent(minSizePercent);
        this.setMinHeightPercent(minSizePercent);
        return this;
    }

    @Override
    public YogaNode setMaxSize(float maxSize) {
        this.setMaxWidth(maxSize);
        this.setMaxHeight(maxSize);
        return this;
    }

    @Override
    public YogaNode setMaxSizePercent(float maxSizePercent) {
        this.setMaxWidthPercent(maxSizePercent);
        this.setMaxHeightPercent(maxSizePercent);
        return this;
    }

    @Override
    public YogaNode setSizeAuto() {
        this.setWidthAuto();
        this.setHeightAuto();
        return this;
    }

    @Override
    public float getAspectRatio() {
        return GlobalMembers.YGNodeStyleGetAspectRatio(this.mNativePointer);
    }

    @Override
    public YogaNode setAspectRatio(float aspectRatio) {
        GlobalMembers.YGNodeStyleSetAspectRatio(this.mNativePointer, aspectRatio);
        return this;
    }

    @Override
    public YogaNode setBackground(Drawable background) {
        this.background = background;
        this.setPadding(YogaEdge.LEFT, background.getLeftWidth());
        this.setPadding(YogaEdge.TOP, background.getTopHeight());
        this.setPadding(YogaEdge.RIGHT, background.getRightWidth());
        this.setPadding(YogaEdge.BOTTOM, background.getBottomHeight());
        return this;
    }

    @Override
    public Drawable getBackground() {
        return this.background;
    }

    @Override
    public void setMeasureFunction(YogaMeasureFunction measureFunction) {
        this.mMeasureFunction = measureFunction;
        this.mNativePointer.getMeasure().noContext = (node, width, widthMode, height, heightMode) -> this.measure(width, widthMode.getValue(), height, heightMode.getValue());
    }

    public final YGSize measure(float width, int widthMode, float height, int heightMode) {
        if (!this.isMeasureDefined()) {
            throw new RuntimeException("Measure function isn't defined!");
        }
        return this.mMeasureFunction.measure(this, width, YogaMeasureMode.fromInt(widthMode), height, YogaMeasureMode.fromInt(heightMode));
    }

    @Override
    public YogaNode setBaselineFunction(YogaBaselineFunction baselineFunction) {
        this.mBaselineFunction = baselineFunction;
        this.mNativePointer.setBaselineFunc((node, width, height) -> this.baseline(width, height));
        return this;
    }

    public final float baseline(float width, float height) {
        return this.mBaselineFunction.baseline(this, width, height);
    }

    @Override
    public boolean isMeasureDefined() {
        return this.mMeasureFunction != null;
    }

    @Override
    public boolean isBaselineDefined() {
        return this.mBaselineFunction != null;
    }

    @Override
    public Object getData() {
        return this.mData;
    }

    @Override
    public YogaNode setData(Object data) {
        this.mData = data;
        return this;
    }

    @Override
    public void print() {
    }

    private final YGNode replaceChild(YogaNodeWrapper newNode, int childIndex) {
        if (this.mChildren == null) {
            throw new IllegalStateException("Cannot replace child. YogaNode does not have children");
        }
        this.mChildren.remove(childIndex);
        this.mChildren.add(childIndex, newNode);
        newNode.mOwner = this;
        return newNode.mNativePointer;
    }

    @Override
    public float getLayoutX() {
        return GlobalMembers.YGNodeLayoutGetLeft(this.mNativePointer);
    }

    @Override
    public float getLayoutY() {
        return GlobalMembers.YGNodeLayoutGetTop(this.mNativePointer);
    }

    @Override
    public float getLayoutWidth() {
        return GlobalMembers.YGNodeLayoutGetWidth(this.mNativePointer);
    }

    @Override
    public float getLayoutHeight() {
        return GlobalMembers.YGNodeLayoutGetHeight(this.mNativePointer);
    }

    public boolean getDoesLegacyStretchFlagAffectsLayout() {
        return GlobalMembers.YGNodeLayoutGetDidLegacyStretchFlagAffectLayout(this.mNativePointer);
    }

    @Override
    public float getLayoutMargin(YogaEdge edge) {
        return GlobalMembers.YGNodeLayoutGetMargin(this.mNativePointer, YGEdge.forValue(edge.intValue()));
    }

    @Override
    public float getLayoutPadding(YogaEdge edge) {
        return GlobalMembers.YGNodeLayoutGetPadding(this.mNativePointer, YGEdge.forValue(edge.intValue()));
    }

    @Override
    public float getLayoutBorder(YogaEdge edge) {
        return GlobalMembers.YGNodeLayoutGetBorder(this.mNativePointer, YGEdge.forValue(edge.intValue()));
    }

    @Override
    public YogaDirection getLayoutDirection() {
        return YogaDirection.fromInt(GlobalMembers.YGNodeLayoutGetDirection(this.mNativePointer).getValue());
    }

    @Override
    public boolean hasNewLayout() {
        return GlobalMembers.YGNodeGetHasNewLayout(this.mNativePointer);
    }

    @Override
    public void markLayoutSeen() {
        GlobalMembers.YGNodeSetHasNewLayout(this.mNativePointer, false);
    }
}

