/*
 * Decompiled with CFR 0.152.
 */
package io.github.orioncraftmc.meditate.internal;

import io.github.orioncraftmc.meditate.internal.YGCachedMeasurement;
import io.github.orioncraftmc.meditate.internal.YGCollectFlexItemsRowValues;
import io.github.orioncraftmc.meditate.internal.YGConfig;
import io.github.orioncraftmc.meditate.internal.YGFloatOptional;
import io.github.orioncraftmc.meditate.internal.YGLayout;
import io.github.orioncraftmc.meditate.internal.YGNode;
import io.github.orioncraftmc.meditate.internal.YGSize;
import io.github.orioncraftmc.meditate.internal.YGStyle;
import io.github.orioncraftmc.meditate.internal.YGValue;
import io.github.orioncraftmc.meditate.internal.detail.CompactValue;
import io.github.orioncraftmc.meditate.internal.detail.Log;
import io.github.orioncraftmc.meditate.internal.detail.RefObject;
import io.github.orioncraftmc.meditate.internal.detail.Values;
import io.github.orioncraftmc.meditate.internal.enums.YGAlign;
import io.github.orioncraftmc.meditate.internal.enums.YGDimension;
import io.github.orioncraftmc.meditate.internal.enums.YGDirection;
import io.github.orioncraftmc.meditate.internal.enums.YGDisplay;
import io.github.orioncraftmc.meditate.internal.enums.YGEdge;
import io.github.orioncraftmc.meditate.internal.enums.YGExperimentalFeature;
import io.github.orioncraftmc.meditate.internal.enums.YGFlexDirection;
import io.github.orioncraftmc.meditate.internal.enums.YGJustify;
import io.github.orioncraftmc.meditate.internal.enums.YGLogLevel;
import io.github.orioncraftmc.meditate.internal.enums.YGMeasureMode;
import io.github.orioncraftmc.meditate.internal.enums.YGNodeType;
import io.github.orioncraftmc.meditate.internal.enums.YGOverflow;
import io.github.orioncraftmc.meditate.internal.enums.YGPositionType;
import io.github.orioncraftmc.meditate.internal.enums.YGPrintOptions;
import io.github.orioncraftmc.meditate.internal.enums.YGUnit;
import io.github.orioncraftmc.meditate.internal.enums.YGWrap;
import io.github.orioncraftmc.meditate.internal.event.Event;
import io.github.orioncraftmc.meditate.internal.event.LayoutData;
import io.github.orioncraftmc.meditate.internal.event.LayoutPassEndEventData;
import io.github.orioncraftmc.meditate.internal.event.LayoutPassReason;
import io.github.orioncraftmc.meditate.internal.event.LayoutPassStartEventData;
import io.github.orioncraftmc.meditate.internal.event.LayoutType;
import io.github.orioncraftmc.meditate.internal.event.MeasureCallbackEndEventData;
import io.github.orioncraftmc.meditate.internal.event.NodeAllocationEventData;
import io.github.orioncraftmc.meditate.internal.event.NodeDeallocationEventData;
import io.github.orioncraftmc.meditate.internal.event.NodeLayoutEventData;
import io.github.orioncraftmc.meditate.internal.interfaces.YGBaselineFunc;
import io.github.orioncraftmc.meditate.internal.interfaces.YGCloneNodeFunc;
import io.github.orioncraftmc.meditate.internal.interfaces.YGDirtiedFunc;
import io.github.orioncraftmc.meditate.internal.interfaces.YGLogger;
import io.github.orioncraftmc.meditate.internal.interfaces.YGMeasureFunc;
import io.github.orioncraftmc.meditate.internal.interfaces.YGNodeCleanupFunc;
import io.github.orioncraftmc.meditate.internal.interfaces.YGPrintFunc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class GlobalMembers {
    public static final float YGUndefined = Float.NaN;
    public static final YGValue YGValueAuto = new YGValue(Float.NaN, YGUnit.YGUnitAuto);
    public static final YGValue YGValueUndefined = new YGValue(Float.NaN, YGUnit.YGUnitUndefined);
    public static final YGValue YGValueZero = new YGValue(0.0f, YGUnit.YGUnitPoint);
    public static final ArrayList<YGEdge> leading;
    public static final ArrayList<YGEdge> trailing;
    public static final ArrayList<YGEdge> pos;
    public static final ArrayList<YGDimension> dim;
    public static final String spacer = "                                                            ";
    public static final float kDefaultFlexGrow = 0.0f;
    public static final float kDefaultFlexShrink = 0.0f;
    public static final float kWebDefaultFlexShrink = 1.0f;
    public static final YGConfig defaultConfig;
    public static final AtomicInteger gCurrentGenerationCount;
    public static final boolean gPrintChanges = false;
    public static final boolean gPrintSkips = false;
    public static int gConfigInstanceCount;

    public static boolean isUndefined(float value) {
        return Float.isNaN(value);
    }

    public static boolean isUndefined(double value) {
        return Double.isNaN(value);
    }

    public static boolean YGValueEqual(YGValue a, YGValue b) {
        if (a.unit != b.unit) {
            return false;
        }
        if (a.unit == YGUnit.YGUnitUndefined || GlobalMembers.isUndefined(a.value) && GlobalMembers.isUndefined(b.value)) {
            return true;
        }
        return Math.abs(a.value - b.value) < 1.0E-4f;
    }

    public static boolean YGValueEqual(CompactValue a, CompactValue b) {
        return GlobalMembers.YGValueEqual(a.convertToYgValue(), b.convertToYgValue());
    }

    public static boolean YGFloatsEqual(float a, float b) {
        if (!GlobalMembers.isUndefined(a) && !GlobalMembers.isUndefined(b)) {
            return Math.abs(a - b) < 1.0E-4f;
        }
        return GlobalMembers.isUndefined(a) && GlobalMembers.isUndefined(b);
    }

    public static boolean YGDoubleEqual(double a, double b) {
        if (!GlobalMembers.isUndefined(a) && !GlobalMembers.isUndefined(b)) {
            return Math.abs(a - b) < 1.0E-4;
        }
        return GlobalMembers.isUndefined(a) && GlobalMembers.isUndefined(b);
    }

    public static float YGFloatMax(float a, float b) {
        if (!GlobalMembers.isUndefined(a) && !GlobalMembers.isUndefined(b)) {
            return Math.max(a, b);
        }
        return GlobalMembers.isUndefined(a) ? b : a;
    }

    public static YGFloatOptional YGFloatOptionalMax(YGFloatOptional op1, YGFloatOptional op2) {
        if (GlobalMembers.greaterThanOrEqualTo(op1, op2)) {
            return op1;
        }
        if (GlobalMembers.greaterThan(op2, op1)) {
            return op2;
        }
        return op1.isUndefined() ? op2 : op1;
    }

    public static float YGFloatMin(float a, float b) {
        if (!GlobalMembers.isUndefined(a) && !GlobalMembers.isUndefined(b)) {
            return Math.min(a, b);
        }
        return GlobalMembers.isUndefined(a) ? b : a;
    }

    public static boolean YGFloatArrayEqual(ArrayList<Float> val1, ArrayList<Float> val2) {
        boolean areEqual = true;
        for (int i = 0; i < val1.size() && areEqual; ++i) {
            areEqual = GlobalMembers.YGFloatsEqual(val1.get(i).floatValue(), val2.get(i).floatValue());
        }
        return areEqual;
    }

    public static float YGFloatSanitize(float val) {
        return GlobalMembers.isUndefined(val) ? 0.0f : val;
    }

    public static YGFlexDirection YGFlexDirectionCross(YGFlexDirection flexDirection, YGDirection direction) {
        return GlobalMembers.YGFlexDirectionIsColumn(flexDirection) ? GlobalMembers.YGResolveFlexDirection(YGFlexDirection.YGFlexDirectionRow, direction) : YGFlexDirection.YGFlexDirectionColumn;
    }

    public static boolean YGFlexDirectionIsRow(YGFlexDirection flexDirection) {
        return flexDirection == YGFlexDirection.YGFlexDirectionRow || flexDirection == YGFlexDirection.YGFlexDirectionRowReverse;
    }

    public static YGFloatOptional YGResolveValue(YGValue value, float ownerSize) {
        switch (value.unit) {
            case YGUnitPoint: {
                return new YGFloatOptional(value.value);
            }
            case YGUnitPercent: {
                return new YGFloatOptional(value.value * ownerSize * 0.01f);
            }
        }
        return new YGFloatOptional();
    }

    public static YGFloatOptional YGResolveValue(CompactValue value, float ownerSize) {
        return GlobalMembers.YGResolveValue(value.convertToYgValue(), ownerSize);
    }

    public static boolean YGFlexDirectionIsColumn(YGFlexDirection flexDirection) {
        return flexDirection == YGFlexDirection.YGFlexDirectionColumn || flexDirection == YGFlexDirection.YGFlexDirectionColumnReverse;
    }

    public static YGFlexDirection YGResolveFlexDirection(YGFlexDirection flexDirection, YGDirection direction) {
        if (direction == YGDirection.YGDirectionRTL) {
            if (flexDirection == YGFlexDirection.YGFlexDirectionRow) {
                return YGFlexDirection.YGFlexDirectionRowReverse;
            }
            if (flexDirection == YGFlexDirection.YGFlexDirectionRowReverse) {
                return YGFlexDirection.YGFlexDirectionRow;
            }
        }
        return flexDirection;
    }

    public static YGFloatOptional YGResolveValueMargin(CompactValue value, float ownerSize) {
        return value.isAuto() ? new YGFloatOptional(0.0f) : GlobalMembers.YGResolveValue(value, ownerSize);
    }

    public static String YGAlignToString(YGAlign value) {
        switch (value) {
            case YGAlignAuto: {
                return "auto";
            }
            case YGAlignFlexStart: {
                return "flex-start";
            }
            case YGAlignCenter: {
                return "center";
            }
            case YGAlignFlexEnd: {
                return "flex-end";
            }
            case YGAlignStretch: {
                return "stretch";
            }
            case YGAlignBaseline: {
                return "baseline";
            }
            case YGAlignSpaceBetween: {
                return "space-between";
            }
            case YGAlignSpaceAround: {
                return "space-around";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String LayoutPassReasonToString(LayoutPassReason value) {
        if (value == LayoutPassReason.kInitial) {
            return "initial";
        }
        if (value == LayoutPassReason.kAbsLayout) {
            return "abs_layout";
        }
        if (value == LayoutPassReason.kStretch) {
            return "stretch";
        }
        if (value == LayoutPassReason.kMultilineStretch) {
            return "multiline_stretch";
        }
        if (value == LayoutPassReason.kFlexLayout) {
            return "flex_layout";
        }
        if (value == LayoutPassReason.kMeasureChild) {
            return "measure";
        }
        if (value == LayoutPassReason.kAbsMeasureChild) {
            return "abs_measure";
        }
        if (value == LayoutPassReason.kFlexMeasure) {
            return "flex_measure";
        }
        return "unknown";
    }

    public static String YGDimensionToString(YGDimension value) {
        switch (value) {
            case YGDimensionWidth: {
                return "width";
            }
            case YGDimensionHeight: {
                return "height";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String YGDirectionToString(YGDirection value) {
        switch (value) {
            case YGDirectionInherit: {
                return "inherit";
            }
            case YGDirectionLTR: {
                return "ltr";
            }
            case YGDirectionRTL: {
                return "rtl";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String YGDisplayToString(YGDisplay value) {
        switch (value) {
            case YGDisplayFlex: {
                return "flex";
            }
            case YGDisplayNone: {
                return "none";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String YGEdgeToString(YGEdge value) {
        switch (value) {
            case YGEdgeLeft: {
                return "left";
            }
            case YGEdgeTop: {
                return "top";
            }
            case YGEdgeRight: {
                return "right";
            }
            case YGEdgeBottom: {
                return "bottom";
            }
            case YGEdgeStart: {
                return "start";
            }
            case YGEdgeEnd: {
                return "end";
            }
            case YGEdgeHorizontal: {
                return "horizontal";
            }
            case YGEdgeVertical: {
                return "vertical";
            }
            case YGEdgeAll: {
                return "all";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String YGExperimentalFeatureToString(YGExperimentalFeature value) {
        if (value == YGExperimentalFeature.YGExperimentalFeatureWebFlexBasis) {
            return "web-flex-basis";
        }
        return "unknown";
    }

    public static String YGFlexDirectionToString(YGFlexDirection value) {
        switch (value) {
            case YGFlexDirectionColumn: {
                return "column";
            }
            case YGFlexDirectionColumnReverse: {
                return "column-reverse";
            }
            case YGFlexDirectionRow: {
                return "row";
            }
            case YGFlexDirectionRowReverse: {
                return "row-reverse";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String YGJustifyToString(YGJustify value) {
        switch (value) {
            case YGJustifyFlexStart: {
                return "flex-start";
            }
            case YGJustifyCenter: {
                return "center";
            }
            case YGJustifyFlexEnd: {
                return "flex-end";
            }
            case YGJustifySpaceBetween: {
                return "space-between";
            }
            case YGJustifySpaceAround: {
                return "space-around";
            }
            case YGJustifySpaceEvenly: {
                return "space-evenly";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String YGLogLevelToString(YGLogLevel value) {
        switch (value) {
            case YGLogLevelError: {
                return "error";
            }
            case YGLogLevelWarn: {
                return "warn";
            }
            case YGLogLevelInfo: {
                return "info";
            }
            case YGLogLevelDebug: {
                return "debug";
            }
            case YGLogLevelVerbose: {
                return "verbose";
            }
            case YGLogLevelFatal: {
                return "fatal";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String YGMeasureModeToString(YGMeasureMode value) {
        switch (value) {
            case YGMeasureModeUndefined: {
                return "undefined";
            }
            case YGMeasureModeExactly: {
                return "exactly";
            }
            case YGMeasureModeAtMost: {
                return "at-most";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String YGNodeTypeToString(YGNodeType value) {
        switch (value) {
            case YGNodeTypeDefault: {
                return "default";
            }
            case YGNodeTypeText: {
                return "text";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String YGOverflowToString(YGOverflow value) {
        switch (value) {
            case YGOverflowVisible: {
                return "visible";
            }
            case YGOverflowHidden: {
                return "hidden";
            }
            case YGOverflowScroll: {
                return "scroll";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String YGPositionTypeToString(YGPositionType value) {
        switch (value) {
            case YGPositionTypeStatic: {
                return "static";
            }
            case YGPositionTypeRelative: {
                return "relative";
            }
            case YGPositionTypeAbsolute: {
                return "absolute";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String YGPrintOptionsToString(YGPrintOptions value) {
        switch (value) {
            case YGPrintOptionsLayout: {
                return "layout";
            }
            case YGPrintOptionsStyle: {
                return "style";
            }
            case YGPrintOptionsChildren: {
                return "children";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String YGUnitToString(YGUnit value) {
        switch (value) {
            case YGUnitUndefined: {
                return "undefined";
            }
            case YGUnitPoint: {
                return "point";
            }
            case YGUnitPercent: {
                return "percent";
            }
            case YGUnitAuto: {
                return "auto";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String YGWrapToString(YGWrap value) {
        switch (value) {
            case YGWrapNoWrap: {
                return "no-wrap";
            }
            case YGWrapWrap: {
                return "wrap";
            }
            case YGWrapWrapReverse: {
                return "wrap-reverse";
            }
        }
        throw new IllegalArgumentException();
    }

    public static YGNode YGNodeNew() {
        return GlobalMembers.YGNodeNewWithConfig(GlobalMembers.YGConfigGetDefault());
    }

    public static YGNode YGNodeNewWithConfig(YGConfig config) {
        YGNode node = new YGNode(config);
        GlobalMembers.YGAssertWithConfig(config, node != null, "Could not allocate memory for node");
        Event.publish(node, new NodeAllocationEventData(config));
        return node;
    }

    public static YGNode YGNodeClone(YGNode oldNode) {
        YGNode node = new YGNode(oldNode);
        GlobalMembers.YGAssertWithConfig(oldNode.getConfig(), node != null, "Could not allocate memory for node");
        Event.publish(node, new NodeAllocationEventData(node.getConfig()));
        node.setOwner(null);
        return node;
    }

    public static void YGNodeFree(YGNode node) {
        YGNode owner = node.getOwner();
        if (owner != null) {
            owner.removeChild(node);
            node.setOwner(null);
        }
        Integer childCount = GlobalMembers.YGNodeGetChildCount(node);
        Integer i = 0;
        while (i < childCount) {
            YGNode child = GlobalMembers.YGNodeGetChild(node, i);
            if (child != null) {
                child.setOwner(null);
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        node.clearChildren();
        Event.publish(node, new NodeDeallocationEventData(node.getConfig()));
    }

    public static void YGNodeFreeRecursiveWithCleanupFunc(YGNode root, YGNodeCleanupFunc cleanup) {
        int skipped = 0;
        while (GlobalMembers.YGNodeGetChildCount(root) > skipped) {
            YGNode child = GlobalMembers.YGNodeGetChild(root, skipped);
            if (child == null) continue;
            if (child.getOwner() != root) {
                ++skipped;
                continue;
            }
            GlobalMembers.YGNodeRemoveChild(root, child);
            GlobalMembers.YGNodeFreeRecursive(child);
        }
        if (cleanup != null) {
            cleanup.invoke(root);
        }
        GlobalMembers.YGNodeFree(root);
    }

    public static void YGNodeFreeRecursive(YGNode root) {
        GlobalMembers.YGNodeFreeRecursiveWithCleanupFunc(root, null);
    }

    public static void YGNodeReset(YGNode node) {
        node.reset();
    }

    public static void YGNodeInsertChild(YGNode owner, YGNode child, Integer index) {
        GlobalMembers.YGAssertWithNode(owner, child.getOwner() == null, "Child already has a owner, it must be removed first.");
        GlobalMembers.YGAssertWithNode(owner, !owner.hasMeasureFunc(), "Cannot add child: Nodes with measure functions cannot have children.");
        owner.insertChild(child, index);
        child.setOwner(owner);
        owner.markDirtyAndPropogate();
    }

    public static void YGNodeSwapChild(YGNode owner, YGNode child, Integer index) {
        owner.replaceChild(child, index);
        child.setOwner(owner);
    }

    public static void YGNodeRemoveChild(YGNode owner, YGNode excludedChild) {
        if (GlobalMembers.YGNodeGetChildCount(owner) == 0) {
            return;
        }
        YGNode childOwner = excludedChild.getOwner();
        if (owner.removeChild(excludedChild)) {
            if (owner == childOwner) {
                excludedChild.setLayout(null);
                excludedChild.setOwner(null);
            }
            owner.markDirtyAndPropogate();
        }
    }

    public static void YGNodeRemoveAllChildren(YGNode owner) {
        Integer childCount = GlobalMembers.YGNodeGetChildCount(owner);
        if (childCount == 0) {
            return;
        }
        YGNode firstChild = GlobalMembers.YGNodeGetChild(owner, 0);
        if (firstChild != null && firstChild.getOwner() == owner) {
            Integer i = 0;
            while (i < childCount) {
                YGNode oldChild = GlobalMembers.YGNodeGetChild(owner, i);
                oldChild.setLayout(null);
                oldChild.setOwner(null);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            owner.clearChildren();
            owner.markDirtyAndPropogate();
            return;
        }
        owner.getChildren().clear();
        owner.markDirtyAndPropogate();
    }

    public static YGNode YGNodeGetChild(YGNode node, Integer index) {
        if (index < node.getChildren().size()) {
            return node.getChild(index);
        }
        return null;
    }

    public static YGNode YGNodeGetOwner(YGNode node) {
        return node.getOwner();
    }

    public static YGNode YGNodeGetParent(YGNode node) {
        return node.getOwner();
    }

    public static Integer YGNodeGetChildCount(YGNode node) {
        return node.getChildren().size();
    }

    public static void YGNodeSetChildren(YGNode owner, YGNode[] c, Integer count) {
        ArrayList<YGNode> children = new ArrayList<YGNode>(Arrays.asList(c));
        GlobalMembers.YGNodeSetChildrenInternal(owner, children);
    }

    public static void YGNodeSetIsReferenceBaseline(YGNode node, boolean isReferenceBaseline) {
        if (node.isReferenceBaseline() != isReferenceBaseline) {
            node.setIsReferenceBaseline(isReferenceBaseline);
            node.markDirtyAndPropogate();
        }
    }

    public static boolean YGNodeIsReferenceBaseline(YGNode node) {
        return node.isReferenceBaseline();
    }

    public static void YGNodeCalculateLayout(YGNode node, float ownerWidth, float ownerHeight, YGDirection ownerDirection) {
        GlobalMembers.YGNodeCalculateLayoutWithContext(node, ownerWidth, ownerHeight, ownerDirection, null);
    }

    public static void YGNodeMarkDirty(YGNode node) {
        GlobalMembers.YGAssertWithNode(node, node.hasMeasureFunc(), "Only leaf nodes with custom measure functionsshould manually mark themselves as dirty");
        node.markDirtyAndPropogate();
    }

    public static void YGNodeMarkDirtyAndPropogateToDescendants(YGNode node) {
        node.markDirtyAndPropogateDownwards();
    }

    public static boolean YGFloatIsUndefined(float value) {
        return GlobalMembers.isUndefined(value);
    }

    public static boolean YGNodeCanUseCachedMeasurement(YGMeasureMode widthMode, float width, YGMeasureMode heightMode, float height, YGMeasureMode lastWidthMode, float lastWidth, YGMeasureMode lastHeightMode, float lastHeight, float lastComputedWidth, float lastComputedHeight, float marginRow, float marginColumn, YGConfig config) {
        if (!GlobalMembers.YGFloatIsUndefined(lastComputedHeight) && lastComputedHeight < 0.0f || !GlobalMembers.YGFloatIsUndefined(lastComputedWidth) && lastComputedWidth < 0.0f) {
            return false;
        }
        boolean useRoundedComparison = config != null && config.pointScaleFactor != 0.0f;
        float effectiveWidth = useRoundedComparison ? GlobalMembers.YGRoundValueToPixelGrid(width, config.pointScaleFactor, false, false) : width;
        float effectiveHeight = useRoundedComparison ? GlobalMembers.YGRoundValueToPixelGrid(height, config.pointScaleFactor, false, false) : height;
        float effectiveLastWidth = useRoundedComparison ? GlobalMembers.YGRoundValueToPixelGrid(lastWidth, config.pointScaleFactor, false, false) : lastWidth;
        float effectiveLastHeight = useRoundedComparison ? GlobalMembers.YGRoundValueToPixelGrid(lastHeight, config.pointScaleFactor, false, false) : lastHeight;
        boolean hasSameWidthSpec = lastWidthMode == widthMode && GlobalMembers.YGFloatsEqual(effectiveLastWidth, effectiveWidth);
        boolean hasSameHeightSpec = lastHeightMode == heightMode && GlobalMembers.YGFloatsEqual(effectiveLastHeight, effectiveHeight);
        boolean widthIsCompatible = hasSameWidthSpec || GlobalMembers.YGMeasureModeSizeIsExactAndMatchesOldMeasuredSize(widthMode, width - marginRow, lastComputedWidth) || GlobalMembers.YGMeasureModeOldSizeIsUnspecifiedAndStillFits(widthMode, width - marginRow, lastWidthMode, lastComputedWidth) || GlobalMembers.YGMeasureModeNewMeasureSizeIsStricterAndStillValid(widthMode, width - marginRow, lastWidthMode, lastWidth, lastComputedWidth);
        boolean heightIsCompatible = hasSameHeightSpec || GlobalMembers.YGMeasureModeSizeIsExactAndMatchesOldMeasuredSize(heightMode, height - marginColumn, lastComputedHeight) || GlobalMembers.YGMeasureModeOldSizeIsUnspecifiedAndStillFits(heightMode, height - marginColumn, lastHeightMode, lastComputedHeight) || GlobalMembers.YGMeasureModeNewMeasureSizeIsStricterAndStillValid(heightMode, height - marginColumn, lastHeightMode, lastHeight, lastComputedHeight);
        return widthIsCompatible && heightIsCompatible;
    }

    public static void YGNodeCopyStyle(YGNode dstNode, YGNode srcNode) {
        if (dstNode.getStyle() != srcNode.getStyle()) {
            dstNode.setStyle(srcNode.getStyle());
            dstNode.markDirtyAndPropogate();
        }
    }

    public static Object YGNodeGetContext(YGNode node) {
        return node.getContext();
    }

    public static void YGNodeSetContext(YGNode node, Object context) {
        node.setContext(context);
    }

    public static void YGConfigSetPrintTreeFlag(YGConfig config, boolean enabled) {
        config.printTree = enabled;
    }

    public static boolean YGNodeHasMeasureFunc(YGNode node) {
        return node.hasMeasureFunc();
    }

    public static void YGNodeSetMeasureFunc(YGNode node, YGMeasureFunc measureFunc) {
        node.setMeasureFunc(measureFunc);
    }

    public static boolean YGNodeHasBaselineFunc(YGNode node) {
        return node.hasBaselineFunc();
    }

    public static void YGNodeSetBaselineFunc(YGNode node, YGBaselineFunc baselineFunc) {
        node.setBaselineFunc(baselineFunc);
    }

    public static YGDirtiedFunc YGNodeGetDirtiedFunc(YGNode node) {
        return node.getDirtied();
    }

    public static void YGNodeSetDirtiedFunc(YGNode node, YGDirtiedFunc dirtiedFunc) {
        node.setDirtiedFunc(dirtiedFunc);
    }

    public static void YGNodeSetPrintFunc(YGNode node, YGPrintFunc printFunc) {
        node.setPrintFunc(printFunc);
    }

    public static boolean YGNodeGetHasNewLayout(YGNode node) {
        return node.getHasNewLayout();
    }

    public static void YGNodeSetHasNewLayout(YGNode node, boolean hasNewLayout) {
        node.setHasNewLayout(hasNewLayout);
    }

    public static YGNodeType YGNodeGetNodeType(YGNode node) {
        return node.getNodeType();
    }

    public static void YGNodeSetNodeType(YGNode node, YGNodeType nodeType) {
        node.setNodeType(nodeType);
    }

    public static boolean YGNodeIsDirty(YGNode node) {
        return node.isDirty();
    }

    public static boolean YGNodeLayoutGetDidUseLegacyFlag(YGNode node) {
        return node.didUseLegacyFlag();
    }

    public static void YGNodeStyleSetDirection(YGNode node, YGDirection value) {
        GlobalMembers.updateStyle(node, YGDirection.class, value, YGStyle::directionBitfieldRef);
    }

    public static void YGNodeStyleSetFlexDirection(YGNode node, YGFlexDirection flexDirection) {
        GlobalMembers.updateStyle(node, YGFlexDirection.class, flexDirection, YGStyle::flexDirectionBitfieldRef);
    }

    public static void YGNodeStyleSetJustifyContent(YGNode node, YGJustify justifyContent) {
        GlobalMembers.updateStyle(node, YGJustify.class, justifyContent, YGStyle::justifyContentBitfieldRef);
    }

    public static void YGNodeStyleSetAlignContent(YGNode node, YGAlign alignContent) {
        GlobalMembers.updateStyle(node, YGAlign.class, alignContent, YGStyle::alignContentBitfieldRef);
    }

    public static void YGNodeStyleSetAlignItems(YGNode node, YGAlign alignItems) {
        GlobalMembers.updateStyle(node, YGAlign.class, alignItems, YGStyle::alignItemsBitfieldRef);
    }

    public static void YGNodeStyleSetAlignSelf(YGNode node, YGAlign alignSelf) {
        GlobalMembers.updateStyle(node, YGAlign.class, alignSelf, YGStyle::alignSelfBitfieldRef);
    }

    public static void YGNodeStyleSetPositionType(YGNode node, YGPositionType positionType) {
        GlobalMembers.updateStyle(node, YGPositionType.class, positionType, YGStyle::positionTypeBitfieldRef);
    }

    public static void YGNodeStyleSetFlexWrap(YGNode node, YGWrap flexWrap) {
        GlobalMembers.updateStyle(node, YGWrap.class, flexWrap, YGStyle::flexWrapBitfieldRef);
    }

    public static void YGNodeStyleSetOverflow(YGNode node, YGOverflow overflow) {
        GlobalMembers.updateStyle(node, YGOverflow.class, overflow, YGStyle::overflowBitfieldRef);
    }

    public static void YGNodeStyleSetDisplay(YGNode node, YGDisplay display) {
        GlobalMembers.updateStyle(node, YGDisplay.class, display, YGStyle::displayBitfieldRef);
    }

    public static void YGNodeStyleSetFlex(YGNode node, float flex) {
        GlobalMembers.updateStyle(node, Float.valueOf(flex), (ygStyle, val) -> val.floatValue() != ygStyle.flex().unwrap(), (YGStyle ygStyle, T val) -> ygStyle.setFlex(new YGFloatOptional(val.floatValue())));
    }

    public static void YGNodeStyleSetFlexGrow(YGNode node, float flexGrow) {
        GlobalMembers.updateStyle(node, Float.valueOf(flexGrow), (ygStyle, val) -> val.floatValue() != ygStyle.flexGrow().unwrap(), (YGStyle ygStyle, T val) -> ygStyle.setFlexGrow(new YGFloatOptional(val.floatValue())));
    }

    public static void YGNodeStyleSetFlexShrink(YGNode node, float flexShrink) {
        GlobalMembers.updateStyle(node, Float.valueOf(flexShrink), (ygStyle, val) -> val.floatValue() != ygStyle.flexShrink().unwrap(), (YGStyle ygStyle, T val) -> ygStyle.setFlexShrink(new YGFloatOptional(val.floatValue())));
    }

    public static void YGNodeStyleSetFlexBasis(YGNode node, float flexBasis) {
        CompactValue value = CompactValue.ofMaybe(flexBasis, YGUnit.YGUnitPoint);
        GlobalMembers.updateStyle(node, value, (ygStyle, val) -> !CompactValue.equalsTo(ygStyle.flexBasis(), val), (YGStyle ygStyle, T val) -> ygStyle.setFlexBasis(value));
    }

    public static void YGNodeStyleSetFlexBasisPercent(YGNode node, float flexBasisPercent) {
        CompactValue value = CompactValue.ofMaybe(flexBasisPercent, YGUnit.YGUnitPercent);
        GlobalMembers.updateStyle(node, value, (ygStyle, val) -> !CompactValue.equalsTo(ygStyle.flexBasis(), val), (YGStyle ygStyle, T val) -> ygStyle.setFlexBasis(value));
    }

    public static void YGNodeStyleSetFlexBasisAuto(YGNode node) {
        CompactValue value = CompactValue.ofAuto();
        GlobalMembers.updateStyle(node, value, (ygStyle, val) -> !CompactValue.equalsTo(ygStyle.flexBasis(), val), (YGStyle ygStyle, T val) -> ygStyle.setFlexBasis(value));
    }

    public static void YGNodeStyleSetPosition(YGNode node, YGEdge edge, float points) {
        GlobalMembers.updateStyleIndexed(node, edge, points, YGUnit.YGUnitPoint, YGStyle::position);
    }

    public static void YGNodeStyleSetPositionPercent(YGNode node, YGEdge edge, float percent) {
        GlobalMembers.updateStyleIndexed(node, edge, percent, YGUnit.YGUnitPercent, YGStyle::position);
    }

    public static YGValue YGNodeStyleGetPosition(YGNode node, YGEdge edge) {
        return node.getStyle().position().get(edge.getValue());
    }

    public static void YGNodeStyleSetMargin(YGNode node, YGEdge edge, float points) {
        GlobalMembers.updateStyleIndexed(node, edge, points, YGUnit.YGUnitPoint, YGStyle::margin);
    }

    private static <T extends Enum<T>> void updateStyleIndexed(YGNode node, T edge, float value, YGUnit unit, Function<YGStyle, Values<T>> values) {
        GlobalMembers.updateStyleIndexed(node, edge, CompactValue.ofMaybe(value, unit), values);
    }

    private static <T extends Enum<T>> void updateStyleIndexed(YGNode node, T edge, CompactValue value, Function<YGStyle, Values<T>> values) {
        GlobalMembers.updateStyle(node, value, (ygStyle, val) -> !CompactValue.equalsTo(((Values)values.apply(node.getStyle())).getCompactValue(edge.ordinal()), val), (YGStyle ygStyle, T val) -> ((Values)values.apply(node.getStyle())).set((Integer)edge.ordinal(), value));
    }

    public static void YGNodeStyleSetMarginPercent(YGNode node, YGEdge edge, float percent) {
        GlobalMembers.updateStyleIndexed(node, edge, percent, YGUnit.YGUnitPercent, YGStyle::margin);
    }

    public static void YGNodeStyleSetMarginAuto(YGNode node, YGEdge edge) {
        GlobalMembers.updateStyleIndexed(node, edge, CompactValue.ofAuto(), YGStyle::margin);
    }

    public static YGValue YGNodeStyleGetMargin(YGNode node, YGEdge edge) {
        return node.getStyle().margin().get(edge.getValue());
    }

    public static void YGNodeStyleSetPadding(YGNode node, YGEdge edge, float points) {
        GlobalMembers.updateStyleIndexed(node, edge, points, YGUnit.YGUnitPoint, YGStyle::padding);
    }

    public static void YGNodeStyleSetPaddingPercent(YGNode node, YGEdge edge, float percent) {
        GlobalMembers.updateStyleIndexed(node, edge, percent, YGUnit.YGUnitPercent, YGStyle::padding);
    }

    public static YGValue YGNodeStyleGetPadding(YGNode node, YGEdge edge) {
        return node.getStyle().padding().get(edge.getValue());
    }

    public static void YGNodeStyleSetBorder(YGNode node, YGEdge edge, float border) {
        GlobalMembers.updateStyleIndexed(node, edge, border, YGUnit.YGUnitPoint, YGStyle::border);
    }

    public static void YGNodeStyleSetWidth(YGNode node, float points) {
        GlobalMembers.updateStyleIndexed(node, YGDimension.YGDimensionWidth, points, YGUnit.YGUnitPoint, YGStyle::dimensions);
    }

    public static void YGNodeStyleSetWidthPercent(YGNode node, float percent) {
        GlobalMembers.updateStyleIndexed(node, YGDimension.YGDimensionWidth, percent, YGUnit.YGUnitPercent, YGStyle::dimensions);
    }

    public static void YGNodeStyleSetWidthAuto(YGNode node) {
        GlobalMembers.updateStyleIndexed(node, YGDimension.YGDimensionWidth, CompactValue.ofAuto(), YGStyle::dimensions);
    }

    public static YGValue YGNodeStyleGetWidth(YGNode node) {
        return node.getStyle().dimensions().get(YGDimension.YGDimensionWidth.getValue());
    }

    public static void YGNodeStyleSetHeight(YGNode node, float points) {
        GlobalMembers.updateStyleIndexed(node, YGDimension.YGDimensionHeight, points, YGUnit.YGUnitPoint, YGStyle::dimensions);
    }

    public static void YGNodeStyleSetHeightPercent(YGNode node, float percent) {
        GlobalMembers.updateStyleIndexed(node, YGDimension.YGDimensionHeight, percent, YGUnit.YGUnitPercent, YGStyle::dimensions);
    }

    public static void YGNodeStyleSetHeightAuto(YGNode node) {
        GlobalMembers.updateStyleIndexed(node, YGDimension.YGDimensionHeight, CompactValue.ofAuto(), YGStyle::dimensions);
    }

    public static YGValue YGNodeStyleGetHeight(YGNode node) {
        return node.getStyle().dimensions().get(YGDimension.YGDimensionHeight.getValue());
    }

    public static void YGNodeStyleSetMinWidth(YGNode node, float minWidth) {
        GlobalMembers.updateStyleIndexed(node, YGDimension.YGDimensionWidth, minWidth, YGUnit.YGUnitPoint, YGStyle::minDimensions);
    }

    public static void YGNodeStyleSetMinWidthPercent(YGNode node, float minWidth) {
        GlobalMembers.updateStyleIndexed(node, YGDimension.YGDimensionWidth, minWidth, YGUnit.YGUnitPercent, YGStyle::minDimensions);
    }

    public static void YGNodeStyleSetMinHeight(YGNode node, float minHeight) {
        GlobalMembers.updateStyleIndexed(node, YGDimension.YGDimensionHeight, minHeight, YGUnit.YGUnitPoint, YGStyle::minDimensions);
    }

    public static void YGNodeStyleSetMinHeightPercent(YGNode node, float minHeight) {
        GlobalMembers.updateStyleIndexed(node, YGDimension.YGDimensionHeight, minHeight, YGUnit.YGUnitPercent, YGStyle::minDimensions);
    }

    public static void YGNodeStyleSetMaxWidth(YGNode node, float maxWidth) {
        GlobalMembers.updateStyleIndexed(node, YGDimension.YGDimensionWidth, maxWidth, YGUnit.YGUnitPoint, YGStyle::maxDimensions);
    }

    public static void YGNodeStyleSetMaxWidthPercent(YGNode node, float maxWidth) {
        GlobalMembers.updateStyleIndexed(node, YGDimension.YGDimensionWidth, maxWidth, YGUnit.YGUnitPercent, YGStyle::maxDimensions);
    }

    public static void YGNodeStyleSetMaxHeight(YGNode node, float maxHeight) {
        GlobalMembers.updateStyleIndexed(node, YGDimension.YGDimensionHeight, maxHeight, YGUnit.YGUnitPoint, YGStyle::maxDimensions);
    }

    public static void YGNodeStyleSetMaxHeightPercent(YGNode node, float maxHeight) {
        GlobalMembers.updateStyleIndexed(node, YGDimension.YGDimensionHeight, maxHeight, YGUnit.YGUnitPercent, YGStyle::maxDimensions);
    }

    public static void YGNodeStyleSetAspectRatio(YGNode node, float aspectRatio) {
        GlobalMembers.updateStyle(node, Float.valueOf(aspectRatio), (ygStyle, val) -> val.floatValue() != ygStyle.aspectRatio().unwrap(), (YGStyle ygStyle, T val) -> ygStyle.setAspectRatio(new YGFloatOptional(val.floatValue())));
    }

    public static float YGNodeLayoutGetLeft(YGNode node) {
        return node.getLayout().position.get(YGEdge.YGEdgeLeft.getValue()).floatValue();
    }

    public static float YGNodeLayoutGetTop(YGNode node) {
        return node.getLayout().position.get(YGEdge.YGEdgeTop.getValue()).floatValue();
    }

    public static float YGNodeLayoutGetRight(YGNode node) {
        return node.getLayout().position.get(YGEdge.YGEdgeRight.getValue()).floatValue();
    }

    public static float YGNodeLayoutGetBottom(YGNode node) {
        return node.getLayout().position.get(YGEdge.YGEdgeBottom.getValue()).floatValue();
    }

    public static float YGNodeLayoutGetWidth(YGNode node) {
        return node.getLayout().dimensions.get(YGDimension.YGDimensionWidth.getValue()).floatValue();
    }

    public static float YGNodeLayoutGetHeight(YGNode node) {
        return node.getLayout().dimensions.get(YGDimension.YGDimensionHeight.getValue()).floatValue();
    }

    public static YGDirection YGNodeLayoutGetDirection(YGNode node) {
        return node.getLayout().direction();
    }

    public static boolean YGNodeLayoutGetHadOverflow(YGNode node) {
        return node.getLayout().hadOverflow();
    }

    public static boolean YGNodeLayoutGetDidLegacyStretchFlagAffectLayout(YGNode node) {
        return node.getLayout().doesLegacyStretchFlagAffectsLayout();
    }

    public static float YGNodeLayoutGetMargin(YGNode node, YGEdge edge) {
        GlobalMembers.YGAssertWithNode(node, edge.getValue() <= YGEdge.YGEdgeEnd.getValue(), "Cannot get layout properties of multi-edge shorthands");
        if (edge == YGEdge.YGEdgeStart) {
            if (node.getLayout().direction() == YGDirection.YGDirectionRTL) {
                return node.getLayout().margin.get(YGEdge.YGEdgeRight.getValue()).floatValue();
            }
            return node.getLayout().margin.get(YGEdge.YGEdgeLeft.getValue()).floatValue();
        }
        if (edge == YGEdge.YGEdgeEnd) {
            if (node.getLayout().direction() == YGDirection.YGDirectionRTL) {
                return node.getLayout().margin.get(YGEdge.YGEdgeLeft.getValue()).floatValue();
            }
            return node.getLayout().margin.get(YGEdge.YGEdgeRight.getValue()).floatValue();
        }
        return node.getLayout().margin.get(edge.getValue()).floatValue();
    }

    public static float YGNodeLayoutGetBorder(YGNode node, YGEdge edge) {
        GlobalMembers.YGAssertWithNode(node, edge.getValue() <= YGEdge.YGEdgeEnd.getValue(), "Cannot get layout properties of multi-edge shorthands");
        if (edge == YGEdge.YGEdgeStart) {
            if (node.getLayout().direction() == YGDirection.YGDirectionRTL) {
                return node.getLayout().border.get(YGEdge.YGEdgeRight.getValue()).floatValue();
            }
            return node.getLayout().border.get(YGEdge.YGEdgeLeft.getValue()).floatValue();
        }
        if (edge == YGEdge.YGEdgeEnd) {
            if (node.getLayout().direction() == YGDirection.YGDirectionRTL) {
                return node.getLayout().border.get(YGEdge.YGEdgeLeft.getValue()).floatValue();
            }
            return node.getLayout().border.get(YGEdge.YGEdgeRight.getValue()).floatValue();
        }
        return node.getLayout().border.get(edge.getValue()).floatValue();
    }

    public static float YGNodeLayoutGetPadding(YGNode node, YGEdge edge) {
        GlobalMembers.YGAssertWithNode(node, edge.getValue() <= YGEdge.YGEdgeEnd.getValue(), "Cannot get layout properties of multi-edge shorthands");
        if (edge == YGEdge.YGEdgeStart) {
            if (node.getLayout().direction() == YGDirection.YGDirectionRTL) {
                return node.getLayout().padding.get(YGEdge.YGEdgeRight.getValue()).floatValue();
            }
            return node.getLayout().padding.get(YGEdge.YGEdgeLeft.getValue()).floatValue();
        }
        if (edge == YGEdge.YGEdgeEnd) {
            if (node.getLayout().direction() == YGDirection.YGDirectionRTL) {
                return node.getLayout().padding.get(YGEdge.YGEdgeLeft.getValue()).floatValue();
            }
            return node.getLayout().padding.get(YGEdge.YGEdgeRight.getValue()).floatValue();
        }
        return node.getLayout().padding.get(edge.getValue()).floatValue();
    }

    public static void YGConfigSetLogger(YGConfig config, YGLogger logger) {
        if (logger == null) {
            config.setLogger((config1, node, level, format, args) -> GlobalMembers.YGDefaultLog(config1, node, level, format, args));
        } else {
            config.setLogger(logger);
        }
    }

    public static void YGAssert(boolean condition, String message) {
        if (!condition) {
            Log.log((YGNode)null, YGLogLevel.YGLogLevelFatal, null, "%s\n", message);
            throw new RuntimeException(message);
        }
    }

    public static void YGAssertWithNode(YGNode node, boolean condition, String message) {
        if (!condition) {
            Log.log(node, YGLogLevel.YGLogLevelFatal, null, "%s\n", message);
            throw new RuntimeException(message);
        }
    }

    public static void YGAssertWithConfig(YGConfig config, boolean condition, String message) {
        if (!condition) {
            Log.log(config, YGLogLevel.YGLogLevelFatal, null, "%s\n", message);
            throw new RuntimeException(message);
        }
    }

    public static void YGConfigSetPointScaleFactor(YGConfig config, float pixelsInPoint) {
        GlobalMembers.YGAssertWithConfig(config, pixelsInPoint >= 0.0f, "Scale factor should not be less than zero");
        config.pointScaleFactor = pixelsInPoint == 0.0f ? 0.0f : pixelsInPoint;
    }

    public static void YGConfigSetShouldDiffLayoutWithoutLegacyStretchBehaviour(YGConfig config, boolean shouldDiffLayout) {
        config.shouldDiffLayoutWithoutLegacyStretchBehaviour = shouldDiffLayout;
    }

    public static void YGConfigSetUseLegacyStretchBehaviour(YGConfig config, boolean useLegacyStretchBehaviour) {
        config.useLegacyStretchBehaviour = useLegacyStretchBehaviour;
    }

    public static YGConfig YGConfigNew() {
        YGConfig config = new YGConfig(GlobalMembers::YGDefaultLog);
        ++gConfigInstanceCount;
        return config;
    }

    public static void YGConfigFree(YGConfig config) {
        --gConfigInstanceCount;
    }

    public static void YGConfigCopy(YGConfig dest, YGConfig src) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static int YGConfigGetInstanceCount() {
        return gConfigInstanceCount;
    }

    public static void YGConfigSetExperimentalFeatureEnabled(YGConfig config, YGExperimentalFeature feature, boolean enabled) {
        config.experimentalFeatures.set(feature.getValue(), enabled);
    }

    public static boolean YGConfigIsExperimentalFeatureEnabled(YGConfig config, YGExperimentalFeature feature) {
        return config.experimentalFeatures.get(feature.getValue());
    }

    public static void YGConfigSetUseWebDefaults(YGConfig config, boolean enabled) {
        config.useWebDefaults = enabled;
    }

    public static boolean YGConfigGetUseWebDefaults(YGConfig config) {
        return config.useWebDefaults;
    }

    public static void YGConfigSetCloneNodeFunc(YGConfig config, YGCloneNodeFunc callback) {
        config.setCloneNodeCallback(callback);
    }

    public static YGConfig YGConfigGetDefault() {
        return defaultConfig;
    }

    public static void YGConfigSetContext(YGConfig config, Object context) {
        config.context = context;
    }

    public static Object YGConfigGetContext(YGConfig config) {
        return config.context;
    }

    public static float YGRoundValueToPixelGrid(double value, double pointScaleFactor, boolean forceCeil, boolean forceFloor) {
        double scaledValue = value * pointScaleFactor;
        double fractial = scaledValue % 1.0;
        if (fractial < 0.0) {
            fractial += 1.0;
        }
        scaledValue = GlobalMembers.YGDoubleEqual(fractial, 0.0) ? (scaledValue -= fractial) : (GlobalMembers.YGDoubleEqual(fractial, 1.0) ? scaledValue - fractial + 1.0 : (forceCeil ? scaledValue - fractial + 1.0 : (forceFloor ? (scaledValue -= fractial) : scaledValue - fractial + (!GlobalMembers.YGDoubleIsUndefined(fractial) && (fractial > 0.5 || GlobalMembers.YGDoubleEqual(fractial, 0.5)) ? 1.0 : 0.0))));
        return GlobalMembers.YGDoubleIsUndefined(scaledValue) || GlobalMembers.YGDoubleIsUndefined(pointScaleFactor) ? Float.NaN : (float)(scaledValue / pointScaleFactor);
    }

    public static int YGDefaultLog(YGConfig ygConfig, YGNode ygNode, YGLogLevel ygLogLevel, String s, Object ... objects) {
        switch (ygLogLevel) {
            case YGLogLevelError: 
            case YGLogLevelFatal: {
                System.err.println(s + Arrays.toString(objects));
            }
        }
        System.out.println(s + Arrays.toString(objects));
        return 0;
    }

    public static boolean YGDoubleIsUndefined(double value) {
        return GlobalMembers.isUndefined(value);
    }

    public static YGConfig YGConfigClone(YGConfig oldConfig) {
        YGConfig config = oldConfig.shallowClone();
        GlobalMembers.YGAssert(config != null, "Could not allocate memory for config");
        ++gConfigInstanceCount;
        return config;
    }

    public static YGNode YGNodeDeepClone(YGNode oldNode) {
        YGConfig config = null;
        if (oldNode.getConfig() != null) {
            config = GlobalMembers.YGConfigClone(oldNode.getConfig());
        }
        YGNode node = new YGNode(oldNode, config);
        node.setOwner(null);
        Event.publish(node, new NodeAllocationEventData(node.getConfig()));
        ArrayList<YGNode> vec = new ArrayList<YGNode>();
        vec.ensureCapacity(oldNode.getChildren().size());
        for (YGNode item : oldNode.getChildren()) {
            YGNode childNode = GlobalMembers.YGNodeDeepClone(item);
            childNode.setOwner(node);
            vec.add(childNode);
        }
        node.setChildren(vec);
        return new YGNode(node);
    }

    public static void YGConfigFreeRecursive(YGNode root) {
        if (root.getConfig() != null) {
            --gConfigInstanceCount;
            root.setConfig(null);
        }
        for (YGNode child : root.getChildren()) {
            GlobalMembers.YGConfigFreeRecursive(child);
        }
    }

    public static void YGNodeSetChildrenInternal(YGNode owner, ArrayList<YGNode> children) {
        if (owner == null) {
            return;
        }
        if (children.size() == 0) {
            if (GlobalMembers.YGNodeGetChildCount(owner) > 0) {
                for (YGNode child : owner.getChildren()) {
                    child.setLayout(null);
                    child.setOwner(null);
                }
                owner.getChildren().clear();
                owner.markDirtyAndPropogate();
            }
        } else {
            if (GlobalMembers.YGNodeGetChildCount(owner) > 0) {
                for (YGNode oldChild : owner.getChildren()) {
                    oldChild.setLayout(null);
                    oldChild.setOwner(null);
                }
            }
            owner.setChildren(children);
            for (YGNode child : children) {
                child.setOwner(owner);
            }
            owner.markDirtyAndPropogate();
        }
    }

    public static void YGNodeSetChildren(YGNode owner, ArrayList<YGNode> children) {
        GlobalMembers.YGNodeSetChildrenInternal(owner, children);
    }

    public static float YGNodeStyleGetFlexGrow(YGNode node) {
        return node.getStyle().flexGrow().isUndefined() ? 0.0f : node.getStyle().flexGrow().unwrap();
    }

    public static float YGNodeStyleGetFlexShrink(YGNode node) {
        return node.getStyle().flexShrink().isUndefined() ? (node.getConfig() != null && node.getConfig().useWebDefaults ? 1.0f : 0.0f) : node.getStyle().flexShrink().unwrap();
    }

    public static <T extends Enum<T>> void updateStyle(YGNode node, Class<T> enumClazz, T value, Function<YGStyle, YGStyle.BitfieldRef<T>> fieldRef) {
        GlobalMembers.updateStyle(node, value, (ygStyle, newVal) -> ((YGStyle.BitfieldRef)fieldRef.apply(node.getStyle())).getValue(enumClazz) != newVal, (YGStyle ygStyle, T newVal) -> ((YGStyle.BitfieldRef)fieldRef.apply(node.getStyle())).setValue(newVal));
    }

    public static <T> void updateStyle(YGNode node, T value, BiFunction<YGStyle, T, Boolean> needsUpdate, BiConsumer<YGStyle, T> update) {
        if (needsUpdate.apply(node.getStyle(), (YGStyle)value).booleanValue()) {
            update.accept(node.getStyle(), (YGStyle)value);
            node.markDirtyAndPropogate();
        }
    }

    public static YGDirection YGNodeStyleGetDirection(YGNode node) {
        return node.getStyle().direction();
    }

    public static YGFlexDirection YGNodeStyleGetFlexDirection(YGNode node) {
        return node.getStyle().flexDirection();
    }

    public static YGJustify YGNodeStyleGetJustifyContent(YGNode node) {
        return node.getStyle().justifyContent();
    }

    public static YGAlign YGNodeStyleGetAlignContent(YGNode node) {
        return node.getStyle().alignContent();
    }

    public static YGAlign YGNodeStyleGetAlignItems(YGNode node) {
        return node.getStyle().alignItems();
    }

    public static YGAlign YGNodeStyleGetAlignSelf(YGNode node) {
        return node.getStyle().alignSelf();
    }

    public static YGPositionType YGNodeStyleGetPositionType(YGNode node) {
        return node.getStyle().positionType();
    }

    public static YGWrap YGNodeStyleGetFlexWrap(YGNode node) {
        return node.getStyle().flexWrap();
    }

    public static YGOverflow YGNodeStyleGetOverflow(YGNode node) {
        return node.getStyle().overflow();
    }

    public static YGDisplay YGNodeStyleGetDisplay(YGNode node) {
        return node.getStyle().display();
    }

    public static float YGNodeStyleGetFlex(YGNode node) {
        return node.getStyle().flex().isUndefined() ? Float.NaN : node.getStyle().flex().unwrap();
    }

    public static YGValue YGNodeStyleGetFlexBasis(YGNode node) {
        YGValue flexBasis = node.getStyle().flexBasis().convertToYgValue();
        if (flexBasis.unit == YGUnit.YGUnitUndefined || flexBasis.unit == YGUnit.YGUnitAuto) {
            flexBasis.value = Float.NaN;
        }
        return flexBasis;
    }

    public static float YGNodeStyleGetBorder(YGNode node, YGEdge edge) {
        CompactValue border = node.getStyle().border().getCompactValue(edge.getValue());
        if (border.isUndefined() || border.isAuto()) {
            return Float.NaN;
        }
        return border.convertToYgValue().value;
    }

    public static float YGNodeStyleGetAspectRatio(YGNode node) {
        YGFloatOptional op = node.getStyle().aspectRatio();
        return op.isUndefined() ? Float.NaN : op.unwrap();
    }

    public static YGValue YGNodeStyleGetMinWidth(YGNode node) {
        return node.getStyle().minDimensions().get(YGDimension.YGDimensionWidth.getValue());
    }

    public static YGValue YGNodeStyleGetMinHeight(YGNode node) {
        return node.getStyle().minDimensions().get(YGDimension.YGDimensionHeight.getValue());
    }

    public static YGValue YGNodeStyleGetMaxWidth(YGNode node) {
        return node.getStyle().maxDimensions().get(YGDimension.YGDimensionWidth.getValue());
    }

    public static YGValue YGNodeStyleGetMaxHeight(YGNode node) {
        return node.getStyle().maxDimensions().get(YGDimension.YGDimensionHeight.getValue());
    }

    public static boolean YGLayoutNodeInternal(YGNode node, float availableWidth, float availableHeight, YGDirection ownerDirection, YGMeasureMode widthMeasureMode, YGMeasureMode heightMeasureMode, float ownerWidth, float ownerHeight, boolean performLayout, LayoutPassReason reason, YGConfig config, LayoutData layoutMarkerData, Object layoutContext, Integer depth, Integer generationCount) {
        boolean needToVisitNode;
        YGLayout layout = node.getLayout();
        Integer n = depth;
        Integer n2 = depth = Integer.valueOf(depth + 1);
        boolean bl = needToVisitNode = node.isDirty() && layout.generationCount != generationCount || layout.lastOwnerDirection != ownerDirection;
        if (needToVisitNode) {
            layout.nextCachedMeasurementsIndex = 0;
            layout.cachedLayout.availableWidth = -1.0f;
            layout.cachedLayout.availableHeight = -1.0f;
            layout.cachedLayout.widthMeasureMode = YGMeasureMode.YGMeasureModeUndefined;
            layout.cachedLayout.heightMeasureMode = YGMeasureMode.YGMeasureModeUndefined;
            layout.cachedLayout.computedWidth = -1.0f;
            layout.cachedLayout.computedHeight = -1.0f;
        }
        YGCachedMeasurement cachedResults = null;
        if (node.hasMeasureFunc()) {
            float marginAxisColumn;
            float marginAxisRow = node.getMarginForAxis(YGFlexDirection.YGFlexDirectionRow, ownerWidth).unwrap();
            if (GlobalMembers.YGNodeCanUseCachedMeasurement(widthMeasureMode, availableWidth, heightMeasureMode, availableHeight, layout.cachedLayout.widthMeasureMode, layout.cachedLayout.availableWidth, layout.cachedLayout.heightMeasureMode, layout.cachedLayout.availableHeight, layout.cachedLayout.computedWidth, layout.cachedLayout.computedHeight, marginAxisRow, marginAxisColumn = node.getMarginForAxis(YGFlexDirection.YGFlexDirectionColumn, ownerWidth).unwrap(), config)) {
                cachedResults = layout.cachedLayout;
            } else {
                for (int i = 0; i < layout.nextCachedMeasurementsIndex; ++i) {
                    if (!GlobalMembers.YGNodeCanUseCachedMeasurement(widthMeasureMode, availableWidth, heightMeasureMode, availableHeight, layout.cachedMeasurements.get((int)i).widthMeasureMode, layout.cachedMeasurements.get((int)i).availableWidth, layout.cachedMeasurements.get((int)i).heightMeasureMode, layout.cachedMeasurements.get((int)i).availableHeight, layout.cachedMeasurements.get((int)i).computedWidth, layout.cachedMeasurements.get((int)i).computedHeight, marginAxisRow, marginAxisColumn, config)) continue;
                    cachedResults = layout.cachedMeasurements.get(i);
                    break;
                }
            }
        } else if (performLayout) {
            if (GlobalMembers.YGFloatsEqual(layout.cachedLayout.availableWidth, availableWidth) && GlobalMembers.YGFloatsEqual(layout.cachedLayout.availableHeight, availableHeight) && layout.cachedLayout.widthMeasureMode == widthMeasureMode && layout.cachedLayout.heightMeasureMode == heightMeasureMode) {
                cachedResults = layout.cachedLayout;
            }
        } else {
            for (int i = 0; i < layout.nextCachedMeasurementsIndex; ++i) {
                if (!GlobalMembers.YGFloatsEqual(layout.cachedMeasurements.get((int)i).availableWidth, availableWidth) || !GlobalMembers.YGFloatsEqual(layout.cachedMeasurements.get((int)i).availableHeight, availableHeight) || layout.cachedMeasurements.get((int)i).widthMeasureMode != widthMeasureMode || layout.cachedMeasurements.get((int)i).heightMeasureMode != heightMeasureMode) continue;
                cachedResults = layout.cachedMeasurements.get(i);
                break;
            }
        }
        if (!needToVisitNode && cachedResults != null) {
            layout.measuredDimensions.set(YGDimension.YGDimensionWidth.getValue(), Float.valueOf(cachedResults.computedWidth));
            layout.measuredDimensions.set(YGDimension.YGDimensionHeight.getValue(), Float.valueOf(cachedResults.computedHeight));
            if (performLayout) {
                ++layoutMarkerData.cachedLayouts;
            } else {
                ++layoutMarkerData.cachedMeasures;
            }
        } else {
            GlobalMembers.YGNodelayoutImpl(node, availableWidth, availableHeight, ownerDirection, widthMeasureMode, heightMeasureMode, ownerWidth, ownerHeight, performLayout, config, layoutMarkerData, layoutContext, depth, generationCount, reason);
            layout.lastOwnerDirection = ownerDirection;
            if (cachedResults == null) {
                YGCachedMeasurement newCacheEntry;
                if (layout.nextCachedMeasurementsIndex + 1 > layoutMarkerData.maxMeasureCache) {
                    layoutMarkerData.maxMeasureCache = layout.nextCachedMeasurementsIndex + 1;
                }
                if (layout.nextCachedMeasurementsIndex == 8) {
                    layout.nextCachedMeasurementsIndex = 0;
                }
                if (performLayout) {
                    newCacheEntry = layout.cachedLayout;
                } else {
                    newCacheEntry = layout.cachedMeasurements.get(layout.nextCachedMeasurementsIndex);
                    ++layout.nextCachedMeasurementsIndex;
                }
                newCacheEntry.availableWidth = availableWidth;
                newCacheEntry.availableHeight = availableHeight;
                newCacheEntry.widthMeasureMode = widthMeasureMode;
                newCacheEntry.heightMeasureMode = heightMeasureMode;
                newCacheEntry.computedWidth = layout.measuredDimensions.get(YGDimension.YGDimensionWidth.getValue()).floatValue();
                newCacheEntry.computedHeight = layout.measuredDimensions.get(YGDimension.YGDimensionHeight.getValue()).floatValue();
            }
        }
        if (performLayout) {
            node.setLayoutDimension(node.getLayout().measuredDimensions.get(YGDimension.YGDimensionWidth.getValue()).floatValue(), YGDimension.YGDimensionWidth.getValue());
            node.setLayoutDimension(node.getLayout().measuredDimensions.get(YGDimension.YGDimensionHeight.getValue()).floatValue(), YGDimension.YGDimensionHeight.getValue());
            node.setHasNewLayout(true);
            node.setDirty(false);
        }
        layout.generationCount = generationCount;
        LayoutType layoutType = performLayout ? (!needToVisitNode && cachedResults == layout.cachedLayout ? LayoutType.kCachedLayout : LayoutType.kLayout) : (cachedResults != null ? LayoutType.kCachedMeasure : LayoutType.kMeasure);
        Event.publish(node, new NodeLayoutEventData(layoutType, layoutContext));
        return needToVisitNode || cachedResults == null;
    }

    public static float YGNodePaddingAndBorderForAxis(YGNode node, YGFlexDirection axis, float widthSize) {
        return GlobalMembers.plus(node.getLeadingPaddingAndBorder(axis, widthSize), node.getTrailingPaddingAndBorder(axis, widthSize)).unwrap();
    }

    public static YGAlign YGNodeAlignItem(YGNode node, YGNode child) {
        YGAlign align;
        YGAlign yGAlign = align = child.getStyle().alignSelf() == YGAlign.YGAlignAuto ? node.getStyle().alignItems() : child.getStyle().alignSelf();
        if (align == YGAlign.YGAlignBaseline && GlobalMembers.YGFlexDirectionIsColumn(node.getStyle().flexDirection())) {
            return YGAlign.YGAlignFlexStart;
        }
        return align;
    }

    public static float YGBaseline(YGNode node, Object layoutContext) {
        YGNode child;
        if (node.hasBaselineFunc()) {
            Event.publish(node);
            float baseline = node.baseline(node.getLayout().measuredDimensions.get(YGDimension.YGDimensionWidth.getValue()).floatValue(), node.getLayout().measuredDimensions.get(YGDimension.YGDimensionHeight.getValue()).floatValue(), layoutContext);
            Event.publish(node);
            GlobalMembers.YGAssertWithNode(node, !GlobalMembers.YGFloatIsUndefined(baseline), "Expect custom baseline function to not return NaN");
            return baseline;
        }
        YGNode baselineChild = null;
        Integer childCount = GlobalMembers.YGNodeGetChildCount(node);
        Integer i = 0;
        while (i < childCount && ((child = GlobalMembers.YGNodeGetChild(node, i)) == null || child.getLineIndex() <= 0)) {
            if (child.getStyle().positionType() != YGPositionType.YGPositionTypeAbsolute) {
                if (GlobalMembers.YGNodeAlignItem(node, child) == YGAlign.YGAlignBaseline || child.isReferenceBaseline()) {
                    baselineChild = child;
                    break;
                }
                if (baselineChild == null) {
                    baselineChild = child;
                }
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        if (baselineChild == null) {
            return node.getLayout().measuredDimensions.get(YGDimension.YGDimensionHeight.getValue()).floatValue();
        }
        float baseline = GlobalMembers.YGBaseline(baselineChild, layoutContext);
        return baseline + baselineChild.getLayout().position.get(YGEdge.YGEdgeTop.getValue()).floatValue();
    }

    public static boolean YGIsBaselineLayout(YGNode node) {
        if (GlobalMembers.YGFlexDirectionIsColumn(node.getStyle().flexDirection())) {
            return false;
        }
        if (node.getStyle().alignItems() == YGAlign.YGAlignBaseline) {
            return true;
        }
        Integer childCount = GlobalMembers.YGNodeGetChildCount(node);
        Integer i = 0;
        while (i < childCount) {
            YGNode child = GlobalMembers.YGNodeGetChild(node, i);
            if (child != null && child.getStyle().positionType() != YGPositionType.YGPositionTypeAbsolute && child.getStyle().alignSelf() == YGAlign.YGAlignBaseline) {
                return true;
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return false;
    }

    public static float YGNodeDimWithMargin(YGNode node, YGFlexDirection axis, float widthSize) {
        return GlobalMembers.plus(new YGFloatOptional(node.getLayout().measuredDimensions.get(dim.get(axis.getValue()).getValue()).floatValue()), GlobalMembers.plus(node.getLeadingMargin(axis, widthSize), node.getTrailingMargin(axis, widthSize))).unwrap();
    }

    public static boolean YGNodeIsStyleDimDefined(YGNode node, YGFlexDirection axis, float ownerSize) {
        YGValue resolvedDimension = node.getResolvedDimension(dim.get(axis.getValue()).getValue());
        boolean isUndefined = GlobalMembers.YGFloatIsUndefined(resolvedDimension.value);
        boolean isAutoUnit = resolvedDimension.unit == YGUnit.YGUnitAuto;
        boolean isUndefinedUnit = resolvedDimension.unit == YGUnit.YGUnitUndefined;
        boolean isPointUnit = resolvedDimension.unit == YGUnit.YGUnitPoint;
        boolean isDefined = !isUndefined;
        boolean isResolvedValueLessThanZero = resolvedDimension.value < 0.0f;
        boolean isResolvedPointValueNegative = isPointUnit && isDefined && isResolvedValueLessThanZero;
        boolean isPercentUnit = resolvedDimension.unit == YGUnit.YGUnitPercent;
        boolean isOwnerSizeUndefined = GlobalMembers.YGFloatIsUndefined(ownerSize);
        return !isAutoUnit && !isUndefinedUnit && !isResolvedPointValueNegative && (!isPercentUnit || !isDefined || !isResolvedValueLessThanZero && !isOwnerSizeUndefined);
    }

    public static boolean YGNodeIsLayoutDimDefined(YGNode node, YGFlexDirection axis) {
        float value = node.getLayout().measuredDimensions.get(dim.get(axis.getValue()).getValue()).floatValue();
        return !GlobalMembers.YGFloatIsUndefined(value) && value >= 0.0f;
    }

    public static YGFloatOptional YGNodeBoundAxisWithinMinAndMax(YGNode node, YGFlexDirection axis, YGFloatOptional value, float axisSize) {
        YGFloatOptional min = new YGFloatOptional();
        YGFloatOptional max = new YGFloatOptional();
        if (GlobalMembers.YGFlexDirectionIsColumn(axis)) {
            min = GlobalMembers.YGResolveValue(node.getStyle().minDimensions().get(YGDimension.YGDimensionHeight.getValue()), axisSize);
            max = GlobalMembers.YGResolveValue(node.getStyle().maxDimensions().get(YGDimension.YGDimensionHeight.getValue()), axisSize);
        } else if (GlobalMembers.YGFlexDirectionIsRow(axis)) {
            min = GlobalMembers.YGResolveValue(node.getStyle().minDimensions().get(YGDimension.YGDimensionWidth.getValue()), axisSize);
            max = GlobalMembers.YGResolveValue(node.getStyle().maxDimensions().get(YGDimension.YGDimensionWidth.getValue()), axisSize);
        }
        if (GlobalMembers.greaterThanOrEqualTo(max, new YGFloatOptional(0.0f)) && GlobalMembers.greaterThan(value, max)) {
            return max;
        }
        if (GlobalMembers.greaterThanOrEqualTo(min, new YGFloatOptional(0.0f)) && GlobalMembers.lessThan(value, min)) {
            return min;
        }
        return value;
    }

    public static float YGNodeBoundAxis(YGNode node, YGFlexDirection axis, float value, float axisSize, float widthSize) {
        return GlobalMembers.YGFloatMax(GlobalMembers.YGNodeBoundAxisWithinMinAndMax(node, axis, new YGFloatOptional(value), axisSize).unwrap(), GlobalMembers.YGNodePaddingAndBorderForAxis(node, axis, widthSize));
    }

    public static void YGNodeSetChildTrailingPosition(YGNode node, YGNode child, YGFlexDirection axis) {
        float size = child.getLayout().measuredDimensions.get(dim.get(axis.getValue()).getValue()).floatValue();
        child.setLayoutPosition(node.getLayout().measuredDimensions.get(dim.get(axis.getValue()).getValue()).floatValue() - size - child.getLayout().position.get(pos.get(axis.getValue()).getValue()).floatValue(), trailing.get(axis.getValue()).getValue());
    }

    public static void YGConstrainMaxSizeForMode(YGNode node, YGFlexDirection axis, float ownerAxisSize, float ownerWidth, YGMeasureMode mode, RefObject<Float> size) {
        YGFloatOptional maxSize = GlobalMembers.plus(GlobalMembers.YGResolveValue(node.getStyle().maxDimensions().getCompactValue(dim.get(axis.getValue()).getValue()), ownerAxisSize), node.getMarginForAxis(axis, ownerWidth));
        switch (mode) {
            case YGMeasureModeExactly: 
            case YGMeasureModeAtMost: {
                size.argValue = Float.valueOf(maxSize.isUndefined() || ((Float)size.argValue).floatValue() < maxSize.unwrap() ? ((Float)size.argValue).floatValue() : maxSize.unwrap());
                break;
            }
            case YGMeasureModeUndefined: {
                if (maxSize.isUndefined()) break;
                size.argValue = Float.valueOf(maxSize.unwrap());
            }
        }
    }

    public static void YGNodeComputeFlexBasisForChild(YGNode node, YGNode child, float width, YGMeasureMode widthMode, float height, float ownerWidth, float ownerHeight, YGMeasureMode heightMode, YGDirection direction, YGConfig config, LayoutData layoutMarkerData, Object layoutContext, Integer depth, Integer generationCount) {
        YGFlexDirection mainAxis = GlobalMembers.YGResolveFlexDirection(node.getStyle().flexDirection(), direction);
        boolean isMainAxisRow = GlobalMembers.YGFlexDirectionIsRow(mainAxis);
        float mainAxisSize = isMainAxisRow ? width : height;
        float mainAxisownerSize = isMainAxisRow ? ownerWidth : ownerHeight;
        YGFloatOptional resolvedFlexBasis = GlobalMembers.YGResolveValue(child.resolveFlexBasisPtr(), mainAxisownerSize);
        boolean isRowStyleDimDefined = GlobalMembers.YGNodeIsStyleDimDefined(child, YGFlexDirection.YGFlexDirectionRow, ownerWidth);
        boolean isColumnStyleDimDefined = GlobalMembers.YGNodeIsStyleDimDefined(child, YGFlexDirection.YGFlexDirectionColumn, ownerHeight);
        if (!resolvedFlexBasis.isUndefined() && !GlobalMembers.YGFloatIsUndefined(mainAxisSize)) {
            if (child.getConfig() != null && (child.getLayout().computedFlexBasis.isUndefined() || GlobalMembers.YGConfigIsExperimentalFeatureEnabled(child.getConfig(), YGExperimentalFeature.YGExperimentalFeatureWebFlexBasis) && child.getLayout().computedFlexBasisGeneration != generationCount)) {
                YGFloatOptional paddingAndBorder = new YGFloatOptional(GlobalMembers.YGNodePaddingAndBorderForAxis(child, mainAxis, ownerWidth));
                child.setLayoutComputedFlexBasis(GlobalMembers.YGFloatOptionalMax(resolvedFlexBasis, paddingAndBorder));
            }
        } else if (isMainAxisRow && isRowStyleDimDefined) {
            YGFloatOptional paddingAndBorder = new YGFloatOptional(GlobalMembers.YGNodePaddingAndBorderForAxis(child, YGFlexDirection.YGFlexDirectionRow, ownerWidth));
            child.setLayoutComputedFlexBasis(GlobalMembers.YGFloatOptionalMax(GlobalMembers.YGResolveValue(child.getResolvedDimensions().get(YGDimension.YGDimensionWidth.getValue()), ownerWidth), paddingAndBorder));
        } else if (!isMainAxisRow && isColumnStyleDimDefined) {
            YGFloatOptional paddingAndBorder = new YGFloatOptional(GlobalMembers.YGNodePaddingAndBorderForAxis(child, YGFlexDirection.YGFlexDirectionColumn, ownerWidth));
            child.setLayoutComputedFlexBasis(GlobalMembers.YGFloatOptionalMax(GlobalMembers.YGResolveValue(child.getResolvedDimensions().get(YGDimension.YGDimensionHeight.getValue()), ownerHeight), paddingAndBorder));
        } else {
            boolean childHeightStretch;
            boolean childWidthStretch;
            YGStyle childStyle;
            float childWidth = Float.NaN;
            float childHeight = Float.NaN;
            YGMeasureMode childWidthMeasureMode = YGMeasureMode.YGMeasureModeUndefined;
            YGMeasureMode childHeightMeasureMode = YGMeasureMode.YGMeasureModeUndefined;
            float marginRow = child.getMarginForAxis(YGFlexDirection.YGFlexDirectionRow, ownerWidth).unwrap();
            float marginColumn = child.getMarginForAxis(YGFlexDirection.YGFlexDirectionColumn, ownerWidth).unwrap();
            if (isRowStyleDimDefined) {
                childWidth = GlobalMembers.YGResolveValue(child.getResolvedDimensions().get(YGDimension.YGDimensionWidth.getValue()), ownerWidth).unwrap() + marginRow;
                childWidthMeasureMode = YGMeasureMode.YGMeasureModeExactly;
            }
            if (isColumnStyleDimDefined) {
                childHeight = GlobalMembers.YGResolveValue(child.getResolvedDimensions().get(YGDimension.YGDimensionHeight.getValue()), ownerHeight).unwrap() + marginColumn;
                childHeightMeasureMode = YGMeasureMode.YGMeasureModeExactly;
            }
            if ((!isMainAxisRow && node.getStyle().overflow() == YGOverflow.YGOverflowScroll || node.getStyle().overflow() != YGOverflow.YGOverflowScroll) && GlobalMembers.YGFloatIsUndefined(childWidth) && !GlobalMembers.YGFloatIsUndefined(width)) {
                childWidth = width;
                childWidthMeasureMode = YGMeasureMode.YGMeasureModeAtMost;
            }
            if ((isMainAxisRow && node.getStyle().overflow() == YGOverflow.YGOverflowScroll || node.getStyle().overflow() != YGOverflow.YGOverflowScroll) && GlobalMembers.YGFloatIsUndefined(childHeight) && !GlobalMembers.YGFloatIsUndefined(height)) {
                childHeight = height;
                childHeightMeasureMode = YGMeasureMode.YGMeasureModeAtMost;
            }
            if (!(childStyle = child.getStyle()).aspectRatio().isUndefined()) {
                if (!isMainAxisRow && childWidthMeasureMode == YGMeasureMode.YGMeasureModeExactly) {
                    childHeight = marginColumn + (childWidth - marginRow) / childStyle.aspectRatio().unwrap();
                    childHeightMeasureMode = YGMeasureMode.YGMeasureModeExactly;
                } else if (isMainAxisRow && childHeightMeasureMode == YGMeasureMode.YGMeasureModeExactly) {
                    childWidth = marginRow + (childHeight - marginColumn) * childStyle.aspectRatio().unwrap();
                    childWidthMeasureMode = YGMeasureMode.YGMeasureModeExactly;
                }
            }
            boolean hasExactWidth = !GlobalMembers.YGFloatIsUndefined(width) && widthMode == YGMeasureMode.YGMeasureModeExactly;
            boolean bl = childWidthStretch = GlobalMembers.YGNodeAlignItem(node, child) == YGAlign.YGAlignStretch && childWidthMeasureMode != YGMeasureMode.YGMeasureModeExactly;
            if (!isMainAxisRow && !isRowStyleDimDefined && hasExactWidth && childWidthStretch) {
                childWidth = width;
                childWidthMeasureMode = YGMeasureMode.YGMeasureModeExactly;
                if (!childStyle.aspectRatio().isUndefined()) {
                    childHeight = (childWidth - marginRow) / childStyle.aspectRatio().unwrap();
                    childHeightMeasureMode = YGMeasureMode.YGMeasureModeExactly;
                }
            }
            boolean hasExactHeight = !GlobalMembers.YGFloatIsUndefined(height) && heightMode == YGMeasureMode.YGMeasureModeExactly;
            boolean bl2 = childHeightStretch = GlobalMembers.YGNodeAlignItem(node, child) == YGAlign.YGAlignStretch && childHeightMeasureMode != YGMeasureMode.YGMeasureModeExactly;
            if (isMainAxisRow && !isColumnStyleDimDefined && hasExactHeight && childHeightStretch) {
                childHeight = height;
                childHeightMeasureMode = YGMeasureMode.YGMeasureModeExactly;
                if (!childStyle.aspectRatio().isUndefined()) {
                    childWidth = (childHeight - marginColumn) * childStyle.aspectRatio().unwrap();
                    childWidthMeasureMode = YGMeasureMode.YGMeasureModeExactly;
                }
            }
            RefObject<Float> childWidthRef = new RefObject<Float>(Float.valueOf(childWidth));
            GlobalMembers.YGConstrainMaxSizeForMode(child, YGFlexDirection.YGFlexDirectionRow, ownerWidth, ownerWidth, childWidthMeasureMode, childWidthRef);
            GlobalMembers.YGConstrainMaxSizeForMode(child, YGFlexDirection.YGFlexDirectionColumn, ownerHeight, ownerWidth, childHeightMeasureMode, childWidthRef);
            childWidth = ((Float)childWidthRef.argValue).floatValue();
            GlobalMembers.YGLayoutNodeInternal(child, childWidth, childHeight, direction, childWidthMeasureMode, childHeightMeasureMode, ownerWidth, ownerHeight, false, LayoutPassReason.kMeasureChild, config, layoutMarkerData, layoutContext, depth, generationCount);
            child.setLayoutComputedFlexBasis(new YGFloatOptional(GlobalMembers.YGFloatMax(child.getLayout().measuredDimensions.get(dim.get(mainAxis.getValue()).getValue()).floatValue(), GlobalMembers.YGNodePaddingAndBorderForAxis(child, mainAxis, ownerWidth))));
        }
        child.setLayoutComputedFlexBasisGeneration(generationCount);
    }

    public static void YGNodeAbsoluteLayoutChild(YGNode node, YGNode child, float width, YGMeasureMode widthMode, float height, YGDirection direction, YGConfig config, LayoutData layoutMarkerData, Object layoutContext, Integer depth, Integer generationCount) {
        YGFlexDirection mainAxis = GlobalMembers.YGResolveFlexDirection(node.getStyle().flexDirection(), direction);
        YGFlexDirection crossAxis = GlobalMembers.YGFlexDirectionCross(mainAxis, direction);
        boolean isMainAxisRow = GlobalMembers.YGFlexDirectionIsRow(mainAxis);
        float childWidth = Float.NaN;
        float childHeight = Float.NaN;
        float marginRow = child.getMarginForAxis(YGFlexDirection.YGFlexDirectionRow, width).unwrap();
        float marginColumn = child.getMarginForAxis(YGFlexDirection.YGFlexDirectionColumn, width).unwrap();
        if (GlobalMembers.YGNodeIsStyleDimDefined(child, YGFlexDirection.YGFlexDirectionRow, width)) {
            childWidth = GlobalMembers.YGResolveValue(child.getResolvedDimensions().get(YGDimension.YGDimensionWidth.getValue()), width).unwrap() + marginRow;
        } else if (child.isLeadingPositionDefined(YGFlexDirection.YGFlexDirectionRow) && child.isTrailingPosDefined(YGFlexDirection.YGFlexDirectionRow)) {
            childWidth = node.getLayout().measuredDimensions.get(YGDimension.YGDimensionWidth.getValue()).floatValue() - (node.getLeadingBorder(YGFlexDirection.YGFlexDirectionRow) + node.getTrailingBorder(YGFlexDirection.YGFlexDirectionRow)) - (child.getLeadingPosition(YGFlexDirection.YGFlexDirectionRow, width).unwrap() + child.getTrailingPosition(YGFlexDirection.YGFlexDirectionRow, width).unwrap());
            childWidth = GlobalMembers.YGNodeBoundAxis(child, YGFlexDirection.YGFlexDirectionRow, childWidth, width, width);
        }
        if (GlobalMembers.YGNodeIsStyleDimDefined(child, YGFlexDirection.YGFlexDirectionColumn, height)) {
            childHeight = GlobalMembers.YGResolveValue(child.getResolvedDimensions().get(YGDimension.YGDimensionHeight.getValue()), height).unwrap() + marginColumn;
        } else if (child.isLeadingPositionDefined(YGFlexDirection.YGFlexDirectionColumn) && child.isTrailingPosDefined(YGFlexDirection.YGFlexDirectionColumn)) {
            childHeight = node.getLayout().measuredDimensions.get(YGDimension.YGDimensionHeight.getValue()).floatValue() - (node.getLeadingBorder(YGFlexDirection.YGFlexDirectionColumn) + node.getTrailingBorder(YGFlexDirection.YGFlexDirectionColumn)) - (child.getLeadingPosition(YGFlexDirection.YGFlexDirectionColumn, height).unwrap() + child.getTrailingPosition(YGFlexDirection.YGFlexDirectionColumn, height).unwrap());
            childHeight = GlobalMembers.YGNodeBoundAxis(child, YGFlexDirection.YGFlexDirectionColumn, childHeight, height, width);
        }
        YGStyle childStyle = child.getStyle();
        if (GlobalMembers.YGFloatIsUndefined(childWidth) ^ GlobalMembers.YGFloatIsUndefined(childHeight) && !childStyle.aspectRatio().isUndefined()) {
            if (GlobalMembers.YGFloatIsUndefined(childWidth)) {
                childWidth = marginRow + (childHeight - marginColumn) * childStyle.aspectRatio().unwrap();
            } else if (GlobalMembers.YGFloatIsUndefined(childHeight)) {
                childHeight = marginColumn + (childWidth - marginRow) / childStyle.aspectRatio().unwrap();
            }
        }
        if (GlobalMembers.YGFloatIsUndefined(childWidth) || GlobalMembers.YGFloatIsUndefined(childHeight)) {
            YGMeasureMode childHeightMeasureMode;
            YGMeasureMode childWidthMeasureMode = GlobalMembers.YGFloatIsUndefined(childWidth) ? YGMeasureMode.YGMeasureModeUndefined : YGMeasureMode.YGMeasureModeExactly;
            YGMeasureMode yGMeasureMode = childHeightMeasureMode = GlobalMembers.YGFloatIsUndefined(childHeight) ? YGMeasureMode.YGMeasureModeUndefined : YGMeasureMode.YGMeasureModeExactly;
            if (!isMainAxisRow && GlobalMembers.YGFloatIsUndefined(childWidth) && widthMode != YGMeasureMode.YGMeasureModeUndefined && !GlobalMembers.YGFloatIsUndefined(width) && width > 0.0f) {
                childWidth = width;
                childWidthMeasureMode = YGMeasureMode.YGMeasureModeAtMost;
            }
            GlobalMembers.YGLayoutNodeInternal(child, childWidth, childHeight, direction, childWidthMeasureMode, childHeightMeasureMode, childWidth, childHeight, false, LayoutPassReason.kAbsMeasureChild, config, layoutMarkerData, layoutContext, depth, generationCount);
            childWidth = child.getLayout().measuredDimensions.get(YGDimension.YGDimensionWidth.getValue()).floatValue() + child.getMarginForAxis(YGFlexDirection.YGFlexDirectionRow, width).unwrap();
            childHeight = child.getLayout().measuredDimensions.get(YGDimension.YGDimensionHeight.getValue()).floatValue() + child.getMarginForAxis(YGFlexDirection.YGFlexDirectionColumn, width).unwrap();
        }
        GlobalMembers.YGLayoutNodeInternal(child, childWidth, childHeight, direction, YGMeasureMode.YGMeasureModeExactly, YGMeasureMode.YGMeasureModeExactly, childWidth, childHeight, true, LayoutPassReason.kAbsLayout, config, layoutMarkerData, layoutContext, depth, generationCount);
        if (child.isTrailingPosDefined(mainAxis) && !child.isLeadingPositionDefined(mainAxis)) {
            child.setLayoutPosition(node.getLayout().measuredDimensions.get(dim.get(mainAxis.getValue()).getValue()).floatValue() - child.getLayout().measuredDimensions.get(dim.get(mainAxis.getValue()).getValue()).floatValue() - node.getTrailingBorder(mainAxis) - child.getTrailingMargin(mainAxis, width).unwrap() - child.getTrailingPosition(mainAxis, isMainAxisRow ? width : height).unwrap(), leading.get(mainAxis.getValue()).getValue());
        } else if (!child.isLeadingPositionDefined(mainAxis) && node.getStyle().justifyContent() == YGJustify.YGJustifyCenter) {
            child.setLayoutPosition((node.getLayout().measuredDimensions.get(dim.get(mainAxis.getValue()).getValue()).floatValue() - child.getLayout().measuredDimensions.get(dim.get(mainAxis.getValue()).getValue()).floatValue()) / 2.0f, leading.get(mainAxis.getValue()).getValue());
        } else if (!child.isLeadingPositionDefined(mainAxis) && node.getStyle().justifyContent() == YGJustify.YGJustifyFlexEnd) {
            child.setLayoutPosition(node.getLayout().measuredDimensions.get(dim.get(mainAxis.getValue()).getValue()).floatValue() - child.getLayout().measuredDimensions.get(dim.get(mainAxis.getValue()).getValue()).floatValue(), leading.get(mainAxis.getValue()).getValue());
        }
        if (child.isTrailingPosDefined(crossAxis) && !child.isLeadingPositionDefined(crossAxis)) {
            child.setLayoutPosition(node.getLayout().measuredDimensions.get(dim.get(crossAxis.getValue()).getValue()).floatValue() - child.getLayout().measuredDimensions.get(dim.get(crossAxis.getValue()).getValue()).floatValue() - node.getTrailingBorder(crossAxis) - child.getTrailingMargin(crossAxis, width).unwrap() - child.getTrailingPosition(crossAxis, isMainAxisRow ? height : width).unwrap(), leading.get(crossAxis.getValue()).getValue());
        } else if (!child.isLeadingPositionDefined(crossAxis) && GlobalMembers.YGNodeAlignItem(node, child) == YGAlign.YGAlignCenter) {
            child.setLayoutPosition((node.getLayout().measuredDimensions.get(dim.get(crossAxis.getValue()).getValue()).floatValue() - child.getLayout().measuredDimensions.get(dim.get(crossAxis.getValue()).getValue()).floatValue()) / 2.0f, leading.get(crossAxis.getValue()).getValue());
        } else if (!child.isLeadingPositionDefined(crossAxis) && GlobalMembers.YGNodeAlignItem(node, child) == YGAlign.YGAlignFlexEnd ^ node.getStyle().flexWrap() == YGWrap.YGWrapWrapReverse) {
            child.setLayoutPosition(node.getLayout().measuredDimensions.get(dim.get(crossAxis.getValue()).getValue()).floatValue() - child.getLayout().measuredDimensions.get(dim.get(crossAxis.getValue()).getValue()).floatValue(), leading.get(crossAxis.getValue()).getValue());
        }
    }

    public static void YGNodeWithMeasureFuncSetMeasuredDimensions(YGNode node, float availableWidth, float availableHeight, YGMeasureMode widthMeasureMode, YGMeasureMode heightMeasureMode, float ownerWidth, float ownerHeight, LayoutData layoutMarkerData, Object layoutContext, LayoutPassReason reason) {
        float innerHeight;
        GlobalMembers.YGAssertWithNode(node, node.hasMeasureFunc(), "Expected node to have custom measure function");
        if (widthMeasureMode == YGMeasureMode.YGMeasureModeUndefined) {
            availableWidth = Float.NaN;
        }
        if (heightMeasureMode == YGMeasureMode.YGMeasureModeUndefined) {
            availableHeight = Float.NaN;
        }
        ArrayList<Float> padding = node.getLayout().padding;
        ArrayList<Float> border = node.getLayout().border;
        float paddingAndBorderAxisRow = padding.get(YGEdge.YGEdgeLeft.getValue()).floatValue() + padding.get(YGEdge.YGEdgeRight.getValue()).floatValue() + border.get(YGEdge.YGEdgeLeft.getValue()).floatValue() + border.get(YGEdge.YGEdgeRight.getValue()).floatValue();
        float paddingAndBorderAxisColumn = padding.get(YGEdge.YGEdgeTop.getValue()).floatValue() + padding.get(YGEdge.YGEdgeBottom.getValue()).floatValue() + border.get(YGEdge.YGEdgeTop.getValue()).floatValue() + border.get(YGEdge.YGEdgeBottom.getValue()).floatValue();
        float innerWidth = GlobalMembers.YGFloatIsUndefined(availableWidth) ? availableWidth : GlobalMembers.YGFloatMax(0.0f, availableWidth - paddingAndBorderAxisRow);
        float f = innerHeight = GlobalMembers.YGFloatIsUndefined(availableHeight) ? availableHeight : GlobalMembers.YGFloatMax(0.0f, availableHeight - paddingAndBorderAxisColumn);
        if (widthMeasureMode == YGMeasureMode.YGMeasureModeExactly && heightMeasureMode == YGMeasureMode.YGMeasureModeExactly) {
            node.setLayoutMeasuredDimension(GlobalMembers.YGNodeBoundAxis(node, YGFlexDirection.YGFlexDirectionRow, availableWidth, ownerWidth, ownerWidth), YGDimension.YGDimensionWidth.getValue());
            node.setLayoutMeasuredDimension(GlobalMembers.YGNodeBoundAxis(node, YGFlexDirection.YGFlexDirectionColumn, availableHeight, ownerHeight, ownerWidth), YGDimension.YGDimensionHeight.getValue());
        } else {
            Event.publish(node);
            YGSize measuredSize = node.measure(innerWidth, widthMeasureMode, innerHeight, heightMeasureMode, layoutContext);
            ++layoutMarkerData.measureCallbacks;
            layoutMarkerData.measureCallbackReasonsCount.set(reason.getValue(), 1);
            Event.publish(node, new MeasureCallbackEndEventData(layoutContext, innerWidth, widthMeasureMode, innerHeight, heightMeasureMode, measuredSize.width, measuredSize.height, reason));
            node.setLayoutMeasuredDimension(GlobalMembers.YGNodeBoundAxis(node, YGFlexDirection.YGFlexDirectionRow, widthMeasureMode == YGMeasureMode.YGMeasureModeUndefined || widthMeasureMode == YGMeasureMode.YGMeasureModeAtMost ? measuredSize.width + paddingAndBorderAxisRow : availableWidth, ownerWidth, ownerWidth), YGDimension.YGDimensionWidth.getValue());
            node.setLayoutMeasuredDimension(GlobalMembers.YGNodeBoundAxis(node, YGFlexDirection.YGFlexDirectionColumn, heightMeasureMode == YGMeasureMode.YGMeasureModeUndefined || heightMeasureMode == YGMeasureMode.YGMeasureModeAtMost ? measuredSize.height + paddingAndBorderAxisColumn : availableHeight, ownerHeight, ownerWidth), YGDimension.YGDimensionHeight.getValue());
        }
    }

    public static void YGNodeEmptyContainerSetMeasuredDimensions(YGNode node, float availableWidth, float availableHeight, YGMeasureMode widthMeasureMode, YGMeasureMode heightMeasureMode, float ownerWidth, float ownerHeight) {
        ArrayList<Float> padding = node.getLayout().padding;
        ArrayList<Float> border = node.getLayout().border;
        float width = availableWidth;
        if (widthMeasureMode == YGMeasureMode.YGMeasureModeUndefined || widthMeasureMode == YGMeasureMode.YGMeasureModeAtMost) {
            width = padding.get(YGEdge.YGEdgeLeft.getValue()).floatValue() + padding.get(YGEdge.YGEdgeRight.getValue()).floatValue() + border.get(YGEdge.YGEdgeLeft.getValue()).floatValue() + border.get(YGEdge.YGEdgeRight.getValue()).floatValue();
        }
        node.setLayoutMeasuredDimension(GlobalMembers.YGNodeBoundAxis(node, YGFlexDirection.YGFlexDirectionRow, width, ownerWidth, ownerWidth), YGDimension.YGDimensionWidth.getValue());
        float height = availableHeight;
        if (heightMeasureMode == YGMeasureMode.YGMeasureModeUndefined || heightMeasureMode == YGMeasureMode.YGMeasureModeAtMost) {
            height = padding.get(YGEdge.YGEdgeTop.getValue()).floatValue() + padding.get(YGEdge.YGEdgeBottom.getValue()).floatValue() + border.get(YGEdge.YGEdgeTop.getValue()).floatValue() + border.get(YGEdge.YGEdgeBottom.getValue()).floatValue();
        }
        node.setLayoutMeasuredDimension(GlobalMembers.YGNodeBoundAxis(node, YGFlexDirection.YGFlexDirectionColumn, height, ownerHeight, ownerWidth), YGDimension.YGDimensionHeight.getValue());
    }

    public static boolean YGNodeFixedSizeSetMeasuredDimensions(YGNode node, float availableWidth, float availableHeight, YGMeasureMode widthMeasureMode, YGMeasureMode heightMeasureMode, float ownerWidth, float ownerHeight) {
        if (!GlobalMembers.YGFloatIsUndefined(availableWidth) && widthMeasureMode == YGMeasureMode.YGMeasureModeAtMost && availableWidth <= 0.0f || !GlobalMembers.YGFloatIsUndefined(availableHeight) && heightMeasureMode == YGMeasureMode.YGMeasureModeAtMost && availableHeight <= 0.0f || widthMeasureMode == YGMeasureMode.YGMeasureModeExactly && heightMeasureMode == YGMeasureMode.YGMeasureModeExactly) {
            node.setLayoutMeasuredDimension(GlobalMembers.YGNodeBoundAxis(node, YGFlexDirection.YGFlexDirectionRow, GlobalMembers.YGFloatIsUndefined(availableWidth) || widthMeasureMode == YGMeasureMode.YGMeasureModeAtMost && availableWidth < 0.0f ? 0.0f : availableWidth, ownerWidth, ownerWidth), YGDimension.YGDimensionWidth.getValue());
            node.setLayoutMeasuredDimension(GlobalMembers.YGNodeBoundAxis(node, YGFlexDirection.YGFlexDirectionColumn, GlobalMembers.YGFloatIsUndefined(availableHeight) || heightMeasureMode == YGMeasureMode.YGMeasureModeAtMost && availableHeight < 0.0f ? 0.0f : availableHeight, ownerHeight, ownerWidth), YGDimension.YGDimensionHeight.getValue());
            return true;
        }
        return false;
    }

    public static void YGZeroOutLayoutRecursivly(YGNode node, Object layoutContext) {
        node.setLayout(null);
        node.setLayoutDimension(0.0f, 0);
        node.setLayoutDimension(0.0f, 1);
        node.setHasNewLayout(true);
        node.iterChildrenAfterCloningIfNeeded(GlobalMembers::YGZeroOutLayoutRecursivly, layoutContext);
    }

    public static float YGNodeCalculateAvailableInnerDim(YGNode node, YGDimension dimension, float availableDim, float paddingAndBorder, float ownerDim) {
        float availableInnerDim = availableDim - paddingAndBorder;
        if (!GlobalMembers.YGFloatIsUndefined(availableInnerDim)) {
            YGFloatOptional minDimensionOptional = GlobalMembers.YGResolveValue(node.getStyle().minDimensions().get(dimension.getValue()), ownerDim);
            float minInnerDim = minDimensionOptional.isUndefined() ? 0.0f : minDimensionOptional.unwrap() - paddingAndBorder;
            YGFloatOptional maxDimensionOptional = GlobalMembers.YGResolveValue(node.getStyle().maxDimensions().get(dimension.getValue()), ownerDim);
            float maxInnerDim = maxDimensionOptional.isUndefined() ? Float.MAX_VALUE : maxDimensionOptional.unwrap() - paddingAndBorder;
            availableInnerDim = GlobalMembers.YGFloatMax(GlobalMembers.YGFloatMin(availableInnerDim, maxInnerDim), minInnerDim);
        }
        return availableInnerDim;
    }

    public static float YGNodeComputeFlexBasisForChildren(YGNode node, float availableInnerWidth, float availableInnerHeight, YGMeasureMode widthMeasureMode, YGMeasureMode heightMeasureMode, YGDirection direction, YGFlexDirection mainAxis, YGConfig config, boolean performLayout, LayoutData layoutMarkerData, Object layoutContext, Integer depth, Integer generationCount) {
        YGMeasureMode measureModeMainDim;
        float totalOuterFlexBasis = 0.0f;
        YGNode singleFlexChild = null;
        ArrayList<YGNode> children = node.getChildren();
        YGMeasureMode yGMeasureMode = measureModeMainDim = GlobalMembers.YGFlexDirectionIsRow(mainAxis) ? widthMeasureMode : heightMeasureMode;
        if (measureModeMainDim == YGMeasureMode.YGMeasureModeExactly) {
            for (YGNode child : children) {
                if (!child.isNodeFlexible()) continue;
                if (singleFlexChild != null || GlobalMembers.YGFloatsEqual(child.resolveFlexGrow(), 0.0f) || GlobalMembers.YGFloatsEqual(child.resolveFlexShrink(), 0.0f)) {
                    singleFlexChild = null;
                    break;
                }
                singleFlexChild = child;
            }
        }
        for (YGNode child : children) {
            child.resolveDimension();
            if (child.getStyle().display() == YGDisplay.YGDisplayNone) {
                GlobalMembers.YGZeroOutLayoutRecursivly(child, layoutContext);
                child.setHasNewLayout(true);
                child.setDirty(false);
                continue;
            }
            if (performLayout) {
                YGDirection childDirection = child.resolveDirection(direction);
                float mainDim = GlobalMembers.YGFlexDirectionIsRow(mainAxis) ? availableInnerWidth : availableInnerHeight;
                float crossDim = GlobalMembers.YGFlexDirectionIsRow(mainAxis) ? availableInnerHeight : availableInnerWidth;
                child.setPosition(childDirection, mainDim, crossDim, availableInnerWidth);
            }
            if (child.getStyle().positionType() == YGPositionType.YGPositionTypeAbsolute) continue;
            if (child == singleFlexChild) {
                child.setLayoutComputedFlexBasisGeneration(generationCount);
                child.setLayoutComputedFlexBasis(new YGFloatOptional(0.0f));
            } else {
                GlobalMembers.YGNodeComputeFlexBasisForChild(node, child, availableInnerWidth, widthMeasureMode, availableInnerHeight, availableInnerWidth, availableInnerHeight, heightMeasureMode, direction, config, layoutMarkerData, layoutContext, depth, generationCount);
            }
            totalOuterFlexBasis += child.getLayout().computedFlexBasis.unwrap() + child.getMarginForAxis(mainAxis, availableInnerWidth).unwrap();
        }
        return totalOuterFlexBasis;
    }

    public static YGCollectFlexItemsRowValues YGCalculateCollectFlexItemsRowValues(YGNode node, YGDirection ownerDirection, float mainAxisownerSize, float availableInnerWidth, float availableInnerMainDim, Integer startOfLineIndex, Integer lineCount) {
        YGCollectFlexItemsRowValues flexAlgoRowMeasurement = new YGCollectFlexItemsRowValues();
        flexAlgoRowMeasurement.relativeChildren.ensureCapacity(node.getChildren().size());
        float sizeConsumedOnCurrentLineIncludingMinConstraint = 0.0f;
        YGFlexDirection mainAxis = GlobalMembers.YGResolveFlexDirection(node.getStyle().flexDirection(), node.resolveDirection(ownerDirection));
        boolean isNodeFlexWrap = node.getStyle().flexWrap() != YGWrap.YGWrapNoWrap;
        Integer endOfLineIndex = startOfLineIndex;
        while (endOfLineIndex < node.getChildren().size()) {
            YGNode child = node.getChild(endOfLineIndex);
            if (child.getStyle().display() != YGDisplay.YGDisplayNone && child.getStyle().positionType() != YGPositionType.YGPositionTypeAbsolute) {
                child.setLineIndex(lineCount);
                float childMarginMainAxis = child.getMarginForAxis(mainAxis, availableInnerWidth).unwrap();
                float flexBasisWithMinAndMaxConstraints = GlobalMembers.YGNodeBoundAxisWithinMinAndMax(child, mainAxis, child.getLayout().computedFlexBasis, mainAxisownerSize).unwrap();
                if (sizeConsumedOnCurrentLineIncludingMinConstraint + flexBasisWithMinAndMaxConstraints + childMarginMainAxis > availableInnerMainDim && isNodeFlexWrap && flexAlgoRowMeasurement.itemsOnLine > 0) break;
                sizeConsumedOnCurrentLineIncludingMinConstraint += flexBasisWithMinAndMaxConstraints + childMarginMainAxis;
                flexAlgoRowMeasurement.sizeConsumedOnCurrentLine += flexBasisWithMinAndMaxConstraints + childMarginMainAxis;
                ++flexAlgoRowMeasurement.itemsOnLine;
                if (child.isNodeFlexible()) {
                    flexAlgoRowMeasurement.totalFlexGrowFactors += child.resolveFlexGrow();
                    flexAlgoRowMeasurement.totalFlexShrinkScaledFactors += -child.resolveFlexShrink() * child.getLayout().computedFlexBasis.unwrap();
                }
                flexAlgoRowMeasurement.relativeChildren.add(child);
            }
            Integer n = endOfLineIndex;
            Integer n2 = endOfLineIndex = Integer.valueOf(endOfLineIndex + 1);
        }
        if (flexAlgoRowMeasurement.totalFlexGrowFactors > 0.0f && flexAlgoRowMeasurement.totalFlexGrowFactors < 1.0f) {
            flexAlgoRowMeasurement.totalFlexGrowFactors = 1.0f;
        }
        if (flexAlgoRowMeasurement.totalFlexShrinkScaledFactors > 0.0f && flexAlgoRowMeasurement.totalFlexShrinkScaledFactors < 1.0f) {
            flexAlgoRowMeasurement.totalFlexShrinkScaledFactors = 1.0f;
        }
        flexAlgoRowMeasurement.endOfLineIndex = endOfLineIndex;
        return flexAlgoRowMeasurement;
    }

    public static float YGDistributeFreeSpaceSecondPass(YGCollectFlexItemsRowValues collectedFlexItemsValues, YGNode node, YGFlexDirection mainAxis, YGFlexDirection crossAxis, float mainAxisownerSize, float availableInnerMainDim, float availableInnerCrossDim, float availableInnerWidth, float availableInnerHeight, boolean flexBasisOverflows, YGMeasureMode measureModeCrossDim, boolean performLayout, YGConfig config, LayoutData layoutMarkerData, Object layoutContext, Integer depth, Integer generationCount) {
        float deltaFreeSpace = 0.0f;
        boolean isMainAxisRow = GlobalMembers.YGFlexDirectionIsRow(mainAxis);
        boolean isNodeFlexWrap = node.getStyle().flexWrap() != YGWrap.YGWrapNoWrap;
        for (YGNode currentRelativeChild : collectedFlexItemsValues.relativeChildren) {
            YGMeasureMode childCrossMeasureMode;
            float flexGrowFactor;
            float childFlexBasis;
            float updatedMainSize = childFlexBasis = GlobalMembers.YGNodeBoundAxisWithinMinAndMax(currentRelativeChild, mainAxis, currentRelativeChild.getLayout().computedFlexBasis, mainAxisownerSize).unwrap();
            if (!GlobalMembers.YGFloatIsUndefined(collectedFlexItemsValues.remainingFreeSpace) && collectedFlexItemsValues.remainingFreeSpace < 0.0f) {
                float flexShrinkScaledFactor = -currentRelativeChild.resolveFlexShrink() * childFlexBasis;
                if (flexShrinkScaledFactor != 0.0f) {
                    float childSize = !GlobalMembers.YGFloatIsUndefined(collectedFlexItemsValues.totalFlexShrinkScaledFactors) && collectedFlexItemsValues.totalFlexShrinkScaledFactors == 0.0f ? childFlexBasis + flexShrinkScaledFactor : childFlexBasis + collectedFlexItemsValues.remainingFreeSpace / collectedFlexItemsValues.totalFlexShrinkScaledFactors * flexShrinkScaledFactor;
                    updatedMainSize = GlobalMembers.YGNodeBoundAxis(currentRelativeChild, mainAxis, childSize, availableInnerMainDim, availableInnerWidth);
                }
            } else if (!GlobalMembers.YGFloatIsUndefined(collectedFlexItemsValues.remainingFreeSpace) && collectedFlexItemsValues.remainingFreeSpace > 0.0f && !GlobalMembers.YGFloatIsUndefined(flexGrowFactor = currentRelativeChild.resolveFlexGrow()) && flexGrowFactor != 0.0f) {
                updatedMainSize = GlobalMembers.YGNodeBoundAxis(currentRelativeChild, mainAxis, childFlexBasis + collectedFlexItemsValues.remainingFreeSpace / collectedFlexItemsValues.totalFlexGrowFactors * flexGrowFactor, availableInnerMainDim, availableInnerWidth);
            }
            deltaFreeSpace += updatedMainSize - childFlexBasis;
            float marginMain = currentRelativeChild.getMarginForAxis(mainAxis, availableInnerWidth).unwrap();
            float marginCross = currentRelativeChild.getMarginForAxis(crossAxis, availableInnerWidth).unwrap();
            RefObject<Float> childCrossSize = new RefObject<Float>(Float.valueOf(0.0f));
            RefObject<Float> childMainSize = new RefObject<Float>(Float.valueOf(updatedMainSize + marginMain));
            YGMeasureMode childMainMeasureMode = YGMeasureMode.YGMeasureModeExactly;
            YGStyle childStyle = currentRelativeChild.getStyle();
            if (!childStyle.aspectRatio().isUndefined()) {
                childCrossSize.argValue = Float.valueOf(isMainAxisRow ? (((Float)childMainSize.argValue).floatValue() - marginMain) / childStyle.aspectRatio().unwrap() : (((Float)childMainSize.argValue).floatValue() - marginMain) * childStyle.aspectRatio().unwrap());
                childCrossMeasureMode = YGMeasureMode.YGMeasureModeExactly;
                RefObject<Float> refObject = childCrossSize;
                Float.valueOf(((Float)refObject.argValue).floatValue() + marginCross);
                refObject.argValue = refObject.argValue;
            } else if (!(GlobalMembers.YGFloatIsUndefined(availableInnerCrossDim) || GlobalMembers.YGNodeIsStyleDimDefined(currentRelativeChild, crossAxis, availableInnerCrossDim) || measureModeCrossDim != YGMeasureMode.YGMeasureModeExactly || isNodeFlexWrap && flexBasisOverflows || GlobalMembers.YGNodeAlignItem(node, currentRelativeChild) != YGAlign.YGAlignStretch || currentRelativeChild.marginLeadingValue((YGFlexDirection)crossAxis).unit == YGUnit.YGUnitAuto || currentRelativeChild.marginTrailingValue((YGFlexDirection)crossAxis).unit == YGUnit.YGUnitAuto)) {
                childCrossSize.argValue = Float.valueOf(availableInnerCrossDim);
                childCrossMeasureMode = YGMeasureMode.YGMeasureModeExactly;
            } else if (!GlobalMembers.YGNodeIsStyleDimDefined(currentRelativeChild, crossAxis, availableInnerCrossDim)) {
                childCrossSize.argValue = Float.valueOf(availableInnerCrossDim);
                childCrossMeasureMode = GlobalMembers.YGFloatIsUndefined(((Float)childCrossSize.argValue).floatValue()) ? YGMeasureMode.YGMeasureModeUndefined : YGMeasureMode.YGMeasureModeAtMost;
            } else {
                childCrossSize.argValue = Float.valueOf(GlobalMembers.YGResolveValue(currentRelativeChild.getResolvedDimension(dim.get(crossAxis.getValue()).getValue()), availableInnerCrossDim).unwrap() + marginCross);
                boolean isLoosePercentageMeasurement = currentRelativeChild.getResolvedDimension((int)GlobalMembers.dim.get((int)crossAxis.getValue()).getValue()).unit == YGUnit.YGUnitPercent && measureModeCrossDim != YGMeasureMode.YGMeasureModeExactly;
                childCrossMeasureMode = GlobalMembers.YGFloatIsUndefined(((Float)childCrossSize.argValue).floatValue()) || isLoosePercentageMeasurement ? YGMeasureMode.YGMeasureModeUndefined : YGMeasureMode.YGMeasureModeExactly;
            }
            GlobalMembers.YGConstrainMaxSizeForMode(currentRelativeChild, mainAxis, availableInnerMainDim, availableInnerWidth, childMainMeasureMode, childMainSize);
            GlobalMembers.YGConstrainMaxSizeForMode(currentRelativeChild, crossAxis, availableInnerCrossDim, availableInnerWidth, childCrossMeasureMode, childCrossSize);
            boolean requiresStretchLayout = !GlobalMembers.YGNodeIsStyleDimDefined(currentRelativeChild, crossAxis, availableInnerCrossDim) && GlobalMembers.YGNodeAlignItem(node, currentRelativeChild) == YGAlign.YGAlignStretch && currentRelativeChild.marginLeadingValue((YGFlexDirection)crossAxis).unit != YGUnit.YGUnitAuto && currentRelativeChild.marginTrailingValue((YGFlexDirection)crossAxis).unit != YGUnit.YGUnitAuto;
            RefObject<Float> childWidth = isMainAxisRow ? childMainSize : childCrossSize;
            RefObject<Float> childHeight = !isMainAxisRow ? childMainSize : childCrossSize;
            YGMeasureMode childWidthMeasureMode = isMainAxisRow ? childMainMeasureMode : childCrossMeasureMode;
            YGMeasureMode childHeightMeasureMode = !isMainAxisRow ? childMainMeasureMode : childCrossMeasureMode;
            boolean isLayoutPass = performLayout && !requiresStretchLayout;
            GlobalMembers.YGLayoutNodeInternal(currentRelativeChild, ((Float)childWidth.argValue).floatValue(), ((Float)childHeight.argValue).floatValue(), node.getLayout().direction(), childWidthMeasureMode, childHeightMeasureMode, availableInnerWidth, availableInnerHeight, isLayoutPass, isLayoutPass ? LayoutPassReason.kFlexLayout : LayoutPassReason.kFlexMeasure, config, layoutMarkerData, layoutContext, depth, generationCount);
            node.setLayoutHadOverflow(node.getLayout().hadOverflow() | currentRelativeChild.getLayout().hadOverflow());
        }
        return deltaFreeSpace;
    }

    public static void YGDistributeFreeSpaceFirstPass(YGCollectFlexItemsRowValues collectedFlexItemsValues, YGFlexDirection mainAxis, float mainAxisownerSize, float availableInnerMainDim, float availableInnerWidth) {
        float deltaFreeSpace = 0.0f;
        for (YGNode currentRelativeChild : collectedFlexItemsValues.relativeChildren) {
            float flexGrowFactor;
            float boundMainSize;
            float baseMainSize;
            float childFlexBasis = GlobalMembers.YGNodeBoundAxisWithinMinAndMax(currentRelativeChild, mainAxis, currentRelativeChild.getLayout().computedFlexBasis, mainAxisownerSize).unwrap();
            if (collectedFlexItemsValues.remainingFreeSpace < 0.0f) {
                float flexShrinkScaledFactor = -currentRelativeChild.resolveFlexShrink() * childFlexBasis;
                if (GlobalMembers.YGFloatIsUndefined(flexShrinkScaledFactor) || flexShrinkScaledFactor == 0.0f) continue;
                baseMainSize = childFlexBasis + collectedFlexItemsValues.remainingFreeSpace / collectedFlexItemsValues.totalFlexShrinkScaledFactors * flexShrinkScaledFactor;
                boundMainSize = GlobalMembers.YGNodeBoundAxis(currentRelativeChild, mainAxis, baseMainSize, availableInnerMainDim, availableInnerWidth);
                if (GlobalMembers.YGFloatIsUndefined(baseMainSize) || GlobalMembers.YGFloatIsUndefined(boundMainSize) || baseMainSize == boundMainSize) continue;
                deltaFreeSpace += boundMainSize - childFlexBasis;
                collectedFlexItemsValues.totalFlexShrinkScaledFactors -= -currentRelativeChild.resolveFlexShrink() * currentRelativeChild.getLayout().computedFlexBasis.unwrap();
                continue;
            }
            if (GlobalMembers.YGFloatIsUndefined(collectedFlexItemsValues.remainingFreeSpace) || !(collectedFlexItemsValues.remainingFreeSpace > 0.0f) || GlobalMembers.YGFloatIsUndefined(flexGrowFactor = currentRelativeChild.resolveFlexGrow()) || flexGrowFactor == 0.0f) continue;
            baseMainSize = childFlexBasis + collectedFlexItemsValues.remainingFreeSpace / collectedFlexItemsValues.totalFlexGrowFactors * flexGrowFactor;
            boundMainSize = GlobalMembers.YGNodeBoundAxis(currentRelativeChild, mainAxis, baseMainSize, availableInnerMainDim, availableInnerWidth);
            if (GlobalMembers.YGFloatIsUndefined(baseMainSize) || GlobalMembers.YGFloatIsUndefined(boundMainSize) || baseMainSize == boundMainSize) continue;
            deltaFreeSpace += boundMainSize - childFlexBasis;
            collectedFlexItemsValues.totalFlexGrowFactors -= flexGrowFactor;
        }
        collectedFlexItemsValues.remainingFreeSpace -= deltaFreeSpace;
    }

    public static void YGResolveFlexibleLength(YGNode node, YGCollectFlexItemsRowValues collectedFlexItemsValues, YGFlexDirection mainAxis, YGFlexDirection crossAxis, float mainAxisownerSize, float availableInnerMainDim, float availableInnerCrossDim, float availableInnerWidth, float availableInnerHeight, boolean flexBasisOverflows, YGMeasureMode measureModeCrossDim, boolean performLayout, YGConfig config, LayoutData layoutMarkerData, Object layoutContext, Integer depth, Integer generationCount) {
        float originalFreeSpace = collectedFlexItemsValues.remainingFreeSpace;
        GlobalMembers.YGDistributeFreeSpaceFirstPass(collectedFlexItemsValues, mainAxis, mainAxisownerSize, availableInnerMainDim, availableInnerWidth);
        float distributedFreeSpace = GlobalMembers.YGDistributeFreeSpaceSecondPass(collectedFlexItemsValues, node, mainAxis, crossAxis, mainAxisownerSize, availableInnerMainDim, availableInnerCrossDim, availableInnerWidth, availableInnerHeight, flexBasisOverflows, measureModeCrossDim, performLayout, config, layoutMarkerData, layoutContext, depth, generationCount);
        collectedFlexItemsValues.remainingFreeSpace = originalFreeSpace - distributedFreeSpace;
    }

    public static void YGJustifyMainAxis(YGNode node, YGCollectFlexItemsRowValues collectedFlexItemsValues, Integer startOfLineIndex, YGFlexDirection mainAxis, YGFlexDirection crossAxis, YGMeasureMode measureModeMainDim, YGMeasureMode measureModeCrossDim, float mainAxisownerSize, float ownerWidth, float availableInnerMainDim, float availableInnerCrossDim, float availableInnerWidth, boolean performLayout, Object layoutContext) {
        YGStyle style = node.getStyle();
        float leadingPaddingAndBorderMain = node.getLeadingPaddingAndBorder(mainAxis, ownerWidth).unwrap();
        float trailingPaddingAndBorderMain = node.getTrailingPaddingAndBorder(mainAxis, ownerWidth).unwrap();
        if (measureModeMainDim == YGMeasureMode.YGMeasureModeAtMost && collectedFlexItemsValues.remainingFreeSpace > 0.0f) {
            if (!style.minDimensions().getCompactValue(dim.get(mainAxis.getValue()).getValue()).isUndefined() && !GlobalMembers.YGResolveValue(style.minDimensions().getCompactValue(dim.get(mainAxis.getValue()).getValue()), mainAxisownerSize).isUndefined()) {
                float minAvailableMainDim = GlobalMembers.YGResolveValue(style.minDimensions().getCompactValue(dim.get(mainAxis.getValue()).getValue()), mainAxisownerSize).unwrap() - leadingPaddingAndBorderMain - trailingPaddingAndBorderMain;
                float occupiedSpaceByChildNodes = availableInnerMainDim - collectedFlexItemsValues.remainingFreeSpace;
                collectedFlexItemsValues.remainingFreeSpace = GlobalMembers.YGFloatMax(0.0f, minAvailableMainDim - occupiedSpaceByChildNodes);
            } else {
                collectedFlexItemsValues.remainingFreeSpace = 0.0f;
            }
        }
        int numberOfAutoMarginsOnCurrentLine = 0;
        Integer i = startOfLineIndex;
        while (i < collectedFlexItemsValues.endOfLineIndex) {
            Object child = node.getChild(i);
            if (((YGNode)child).getStyle().positionType() != YGPositionType.YGPositionTypeAbsolute) {
                if (((YGNode)child).marginLeadingValue((YGFlexDirection)mainAxis).unit == YGUnit.YGUnitAuto) {
                    ++numberOfAutoMarginsOnCurrentLine;
                }
                if (((YGNode)child).marginTrailingValue((YGFlexDirection)mainAxis).unit == YGUnit.YGUnitAuto) {
                    ++numberOfAutoMarginsOnCurrentLine;
                }
            }
            child = i;
            Integer n = i = Integer.valueOf(i + 1);
        }
        float leadingMainDim = 0.0f;
        float betweenMainDim = 0.0f;
        YGJustify justifyContent = node.getStyle().justifyContent();
        if (numberOfAutoMarginsOnCurrentLine == 0) {
            switch (justifyContent) {
                case YGJustifyCenter: {
                    leadingMainDim = collectedFlexItemsValues.remainingFreeSpace / 2.0f;
                    break;
                }
                case YGJustifyFlexEnd: {
                    leadingMainDim = collectedFlexItemsValues.remainingFreeSpace;
                    break;
                }
                case YGJustifySpaceBetween: {
                    if (collectedFlexItemsValues.itemsOnLine > 1) {
                        betweenMainDim = GlobalMembers.YGFloatMax(collectedFlexItemsValues.remainingFreeSpace, 0.0f) / (float)(collectedFlexItemsValues.itemsOnLine - 1);
                        break;
                    }
                    betweenMainDim = 0.0f;
                    break;
                }
                case YGJustifySpaceEvenly: {
                    leadingMainDim = betweenMainDim = collectedFlexItemsValues.remainingFreeSpace / (float)(collectedFlexItemsValues.itemsOnLine + 1);
                    break;
                }
                case YGJustifySpaceAround: {
                    betweenMainDim = collectedFlexItemsValues.remainingFreeSpace / (float)collectedFlexItemsValues.itemsOnLine;
                    leadingMainDim = betweenMainDim / 2.0f;
                    break;
                }
            }
        }
        collectedFlexItemsValues.mainDim = leadingPaddingAndBorderMain + leadingMainDim;
        collectedFlexItemsValues.crossDim = 0.0f;
        float maxAscentForCurrentLine = 0.0f;
        float maxDescentForCurrentLine = 0.0f;
        boolean isNodeBaselineLayout = GlobalMembers.YGIsBaselineLayout(node);
        Integer i2 = startOfLineIndex;
        while (i2 < collectedFlexItemsValues.endOfLineIndex) {
            YGNode child = node.getChild(i2);
            YGStyle childStyle = child.getStyle();
            YGLayout childLayout = child.getLayout();
            if (childStyle.display() != YGDisplay.YGDisplayNone) {
                if (childStyle.positionType() == YGPositionType.YGPositionTypeAbsolute && child.isLeadingPositionDefined(mainAxis)) {
                    if (performLayout) {
                        child.setLayoutPosition(child.getLeadingPosition(mainAxis, availableInnerMainDim).unwrap() + node.getLeadingBorder(mainAxis) + child.getLeadingMargin(mainAxis, availableInnerWidth).unwrap(), pos.get(mainAxis.getValue()).getValue());
                    }
                } else if (childStyle.positionType() != YGPositionType.YGPositionTypeAbsolute) {
                    boolean canSkipFlex;
                    if (child.marginLeadingValue((YGFlexDirection)mainAxis).unit == YGUnit.YGUnitAuto) {
                        collectedFlexItemsValues.mainDim += collectedFlexItemsValues.remainingFreeSpace / (float)numberOfAutoMarginsOnCurrentLine;
                    }
                    if (performLayout) {
                        child.setLayoutPosition(childLayout.position.get(pos.get(mainAxis.getValue()).getValue()).floatValue() + collectedFlexItemsValues.mainDim, pos.get(mainAxis.getValue()).getValue());
                    }
                    if (child.marginTrailingValue((YGFlexDirection)mainAxis).unit == YGUnit.YGUnitAuto) {
                        collectedFlexItemsValues.mainDim += collectedFlexItemsValues.remainingFreeSpace / (float)numberOfAutoMarginsOnCurrentLine;
                    }
                    boolean bl = canSkipFlex = !performLayout && measureModeCrossDim == YGMeasureMode.YGMeasureModeExactly;
                    if (canSkipFlex) {
                        collectedFlexItemsValues.mainDim += betweenMainDim + child.getMarginForAxis(mainAxis, availableInnerWidth).unwrap() + childLayout.computedFlexBasis.unwrap();
                        collectedFlexItemsValues.crossDim = availableInnerCrossDim;
                    } else {
                        collectedFlexItemsValues.mainDim += betweenMainDim + GlobalMembers.YGNodeDimWithMargin(child, mainAxis, availableInnerWidth);
                        if (isNodeBaselineLayout) {
                            float ascent = GlobalMembers.YGBaseline(child, layoutContext) + child.getLeadingMargin(YGFlexDirection.YGFlexDirectionColumn, availableInnerWidth).unwrap();
                            float descent = child.getLayout().measuredDimensions.get(YGDimension.YGDimensionHeight.getValue()).floatValue() + child.getMarginForAxis(YGFlexDirection.YGFlexDirectionColumn, availableInnerWidth).unwrap() - ascent;
                            maxAscentForCurrentLine = GlobalMembers.YGFloatMax(maxAscentForCurrentLine, ascent);
                            maxDescentForCurrentLine = GlobalMembers.YGFloatMax(maxDescentForCurrentLine, descent);
                        } else {
                            collectedFlexItemsValues.crossDim = GlobalMembers.YGFloatMax(collectedFlexItemsValues.crossDim, GlobalMembers.YGNodeDimWithMargin(child, crossAxis, availableInnerWidth));
                        }
                    }
                } else if (performLayout) {
                    child.setLayoutPosition(childLayout.position.get(pos.get(mainAxis.getValue()).getValue()).floatValue() + node.getLeadingBorder(mainAxis) + leadingMainDim, pos.get(mainAxis.getValue()).getValue());
                }
            }
            Integer n = i2;
            Integer n2 = i2 = Integer.valueOf(i2 + 1);
        }
        collectedFlexItemsValues.mainDim += trailingPaddingAndBorderMain;
        if (isNodeBaselineLayout) {
            collectedFlexItemsValues.crossDim = maxAscentForCurrentLine + maxDescentForCurrentLine;
        }
    }

    private static void YGNodelayoutImpl(YGNode node, float availableWidth, float availableHeight, YGDirection ownerDirection, YGMeasureMode widthMeasureMode, YGMeasureMode heightMeasureMode, float ownerWidth, float ownerHeight, boolean performLayout, YGConfig config, LayoutData layoutMarkerData, Object layoutContext, int depth, int generationCount, LayoutPassReason reason) {
        float childHeight;
        float childWidth;
        boolean flexBasisOverflows;
        GlobalMembers.YGAssertWithNode(node, !GlobalMembers.YGFloatIsUndefined(availableWidth) || widthMeasureMode == YGMeasureMode.YGMeasureModeUndefined, "availableWidth is indefinite so widthMeasureMode must be YGMeasureModeUndefined");
        GlobalMembers.YGAssertWithNode(node, !GlobalMembers.YGFloatIsUndefined(availableHeight) || heightMeasureMode == YGMeasureMode.YGMeasureModeUndefined, "availableHeight is indefinite so heightMeasureMode must be YGMeasureModeUndefined");
        if (performLayout) {
            ++layoutMarkerData.layouts;
        } else {
            ++layoutMarkerData.measures;
        }
        YGDirection direction = node.resolveDirection(ownerDirection);
        node.setLayoutDirection(direction);
        YGFlexDirection flexRowDirection = GlobalMembers.YGResolveFlexDirection(YGFlexDirection.YGFlexDirectionRow, direction);
        YGFlexDirection flexColumnDirection = GlobalMembers.YGResolveFlexDirection(YGFlexDirection.YGFlexDirectionColumn, direction);
        YGEdge startEdge = direction == YGDirection.YGDirectionLTR ? YGEdge.YGEdgeLeft : YGEdge.YGEdgeRight;
        YGEdge endEdge = direction == YGDirection.YGDirectionLTR ? YGEdge.YGEdgeRight : YGEdge.YGEdgeLeft;
        float marginRowLeading = node.getLeadingMargin(flexRowDirection, ownerWidth).unwrap();
        node.setLayoutMargin(marginRowLeading, startEdge.getValue());
        float marginRowTrailing = node.getTrailingMargin(flexRowDirection, ownerWidth).unwrap();
        node.setLayoutMargin(marginRowTrailing, endEdge.getValue());
        float marginColumnLeading = node.getLeadingMargin(flexColumnDirection, ownerWidth).unwrap();
        node.setLayoutMargin(marginColumnLeading, YGEdge.YGEdgeTop.getValue());
        float marginColumnTrailing = node.getTrailingMargin(flexColumnDirection, ownerWidth).unwrap();
        node.setLayoutMargin(marginColumnTrailing, YGEdge.YGEdgeBottom.getValue());
        float marginAxisRow = marginRowLeading + marginRowTrailing;
        float marginAxisColumn = marginColumnLeading + marginColumnTrailing;
        node.setLayoutBorder(node.getLeadingBorder(flexRowDirection), startEdge.getValue());
        node.setLayoutBorder(node.getTrailingBorder(flexRowDirection), endEdge.getValue());
        node.setLayoutBorder(node.getLeadingBorder(flexColumnDirection), YGEdge.YGEdgeTop.getValue());
        node.setLayoutBorder(node.getTrailingBorder(flexColumnDirection), YGEdge.YGEdgeBottom.getValue());
        node.setLayoutPadding(node.getLeadingPadding(flexRowDirection, ownerWidth).unwrap(), startEdge.getValue());
        node.setLayoutPadding(node.getTrailingPadding(flexRowDirection, ownerWidth).unwrap(), endEdge.getValue());
        node.setLayoutPadding(node.getLeadingPadding(flexColumnDirection, ownerWidth).unwrap(), YGEdge.YGEdgeTop.getValue());
        node.setLayoutPadding(node.getTrailingPadding(flexColumnDirection, ownerWidth).unwrap(), YGEdge.YGEdgeBottom.getValue());
        if (node.hasMeasureFunc()) {
            GlobalMembers.YGNodeWithMeasureFuncSetMeasuredDimensions(node, availableWidth - marginAxisRow, availableHeight - marginAxisColumn, widthMeasureMode, heightMeasureMode, ownerWidth, ownerHeight, layoutMarkerData, layoutContext, reason);
            return;
        }
        int childCount = GlobalMembers.YGNodeGetChildCount(node);
        if (childCount == 0) {
            GlobalMembers.YGNodeEmptyContainerSetMeasuredDimensions(node, availableWidth - marginAxisRow, availableHeight - marginAxisColumn, widthMeasureMode, heightMeasureMode, ownerWidth, ownerHeight);
            return;
        }
        if (!performLayout && GlobalMembers.YGNodeFixedSizeSetMeasuredDimensions(node, availableWidth - marginAxisRow, availableHeight - marginAxisColumn, widthMeasureMode, heightMeasureMode, ownerWidth, ownerHeight)) {
            return;
        }
        node.cloneChildrenIfNeeded(layoutContext);
        node.setLayoutHadOverflow(false);
        YGFlexDirection mainAxis = GlobalMembers.YGResolveFlexDirection(node.getStyle().flexDirection(), direction);
        YGFlexDirection crossAxis = GlobalMembers.YGFlexDirectionCross(mainAxis, direction);
        boolean isMainAxisRow = GlobalMembers.YGFlexDirectionIsRow(mainAxis);
        boolean isNodeFlexWrap = node.getStyle().flexWrap() != YGWrap.YGWrapNoWrap;
        float mainAxisownerSize = isMainAxisRow ? ownerWidth : ownerHeight;
        float crossAxisownerSize = isMainAxisRow ? ownerHeight : ownerWidth;
        float paddingAndBorderAxisMain = GlobalMembers.YGNodePaddingAndBorderForAxis(node, mainAxis, ownerWidth);
        float leadingPaddingAndBorderCross = node.getLeadingPaddingAndBorder(crossAxis, ownerWidth).unwrap();
        float trailingPaddingAndBorderCross = node.getTrailingPaddingAndBorder(crossAxis, ownerWidth).unwrap();
        float paddingAndBorderAxisCross = leadingPaddingAndBorderCross + trailingPaddingAndBorderCross;
        YGMeasureMode measureModeMainDim = isMainAxisRow ? widthMeasureMode : heightMeasureMode;
        YGMeasureMode measureModeCrossDim = isMainAxisRow ? heightMeasureMode : widthMeasureMode;
        float paddingAndBorderAxisRow = isMainAxisRow ? paddingAndBorderAxisMain : paddingAndBorderAxisCross;
        float paddingAndBorderAxisColumn = isMainAxisRow ? paddingAndBorderAxisCross : paddingAndBorderAxisMain;
        float availableInnerWidth = GlobalMembers.YGNodeCalculateAvailableInnerDim(node, YGDimension.YGDimensionWidth, availableWidth - marginAxisRow, paddingAndBorderAxisRow, ownerWidth);
        float availableInnerHeight = GlobalMembers.YGNodeCalculateAvailableInnerDim(node, YGDimension.YGDimensionHeight, availableHeight - marginAxisColumn, paddingAndBorderAxisColumn, ownerHeight);
        float availableInnerMainDim = isMainAxisRow ? availableInnerWidth : availableInnerHeight;
        float availableInnerCrossDim = isMainAxisRow ? availableInnerHeight : availableInnerWidth;
        float totalOuterFlexBasis = GlobalMembers.YGNodeComputeFlexBasisForChildren(node, availableInnerWidth, availableInnerHeight, widthMeasureMode, heightMeasureMode, direction, mainAxis, config, performLayout, layoutMarkerData, layoutContext, depth, generationCount);
        boolean bl = flexBasisOverflows = measureModeMainDim != YGMeasureMode.YGMeasureModeUndefined && totalOuterFlexBasis > availableInnerMainDim;
        if (isNodeFlexWrap && flexBasisOverflows && measureModeMainDim == YGMeasureMode.YGMeasureModeAtMost) {
            measureModeMainDim = YGMeasureMode.YGMeasureModeExactly;
        }
        int startOfLineIndex = 0;
        int endOfLineIndex = 0;
        int lineCount = 0;
        float totalLineCrossDim = 0.0f;
        float maxLineMainDim = 0.0f;
        YGCollectFlexItemsRowValues collectedFlexItemsValues = new YGCollectFlexItemsRowValues();
        while (endOfLineIndex < childCount) {
            collectedFlexItemsValues = GlobalMembers.YGCalculateCollectFlexItemsRowValues(node, ownerDirection, mainAxisownerSize, availableInnerWidth, availableInnerMainDim, startOfLineIndex, lineCount);
            endOfLineIndex = collectedFlexItemsValues.endOfLineIndex;
            boolean canSkipFlex = !performLayout && measureModeCrossDim == YGMeasureMode.YGMeasureModeExactly;
            boolean sizeBasedOnContent = false;
            if (measureModeMainDim != YGMeasureMode.YGMeasureModeExactly) {
                float maxInnerMainDim;
                Values<YGDimension> minDimensions = node.getStyle().minDimensions();
                Values<YGDimension> maxDimensions = node.getStyle().maxDimensions();
                float minInnerWidth = GlobalMembers.YGResolveValue(minDimensions.get(YGDimension.YGDimensionWidth.getValue()), ownerWidth).unwrap() - paddingAndBorderAxisRow;
                float maxInnerWidth = GlobalMembers.YGResolveValue(maxDimensions.get(YGDimension.YGDimensionWidth.getValue()), ownerWidth).unwrap() - paddingAndBorderAxisRow;
                float minInnerHeight = GlobalMembers.YGResolveValue(minDimensions.get(YGDimension.YGDimensionHeight.getValue()), ownerHeight).unwrap() - paddingAndBorderAxisColumn;
                float maxInnerHeight = GlobalMembers.YGResolveValue(maxDimensions.get(YGDimension.YGDimensionHeight.getValue()), ownerHeight).unwrap() - paddingAndBorderAxisColumn;
                float minInnerMainDim = isMainAxisRow ? minInnerWidth : minInnerHeight;
                float f = maxInnerMainDim = isMainAxisRow ? maxInnerWidth : maxInnerHeight;
                if (!GlobalMembers.YGFloatIsUndefined(minInnerMainDim) && collectedFlexItemsValues.sizeConsumedOnCurrentLine < minInnerMainDim) {
                    availableInnerMainDim = minInnerMainDim;
                } else if (!GlobalMembers.YGFloatIsUndefined(maxInnerMainDim) && collectedFlexItemsValues.sizeConsumedOnCurrentLine > maxInnerMainDim) {
                    availableInnerMainDim = maxInnerMainDim;
                } else {
                    if (!node.getConfig().useLegacyStretchBehaviour && (GlobalMembers.YGFloatIsUndefined(collectedFlexItemsValues.totalFlexGrowFactors) && collectedFlexItemsValues.totalFlexGrowFactors == 0.0f || GlobalMembers.YGFloatIsUndefined(node.resolveFlexGrow()) && node.resolveFlexGrow() == 0.0f)) {
                        availableInnerMainDim = collectedFlexItemsValues.sizeConsumedOnCurrentLine;
                    }
                    if (node.getConfig().useLegacyStretchBehaviour) {
                        node.setLayoutDidUseLegacyFlag(true);
                    }
                    boolean bl2 = sizeBasedOnContent = !node.getConfig().useLegacyStretchBehaviour;
                }
            }
            if (!sizeBasedOnContent && !GlobalMembers.YGFloatIsUndefined(availableInnerMainDim)) {
                collectedFlexItemsValues.remainingFreeSpace = availableInnerMainDim - collectedFlexItemsValues.sizeConsumedOnCurrentLine;
            } else if (collectedFlexItemsValues.sizeConsumedOnCurrentLine < 0.0f) {
                collectedFlexItemsValues.remainingFreeSpace = -collectedFlexItemsValues.sizeConsumedOnCurrentLine;
            }
            if (!canSkipFlex) {
                GlobalMembers.YGResolveFlexibleLength(node, collectedFlexItemsValues, mainAxis, crossAxis, mainAxisownerSize, availableInnerMainDim, availableInnerCrossDim, availableInnerWidth, availableInnerHeight, flexBasisOverflows, measureModeCrossDim, performLayout, config, layoutMarkerData, layoutContext, depth, generationCount);
            }
            node.setLayoutHadOverflow(node.getLayout().hadOverflow() | collectedFlexItemsValues.remainingFreeSpace < 0.0f);
            GlobalMembers.YGJustifyMainAxis(node, collectedFlexItemsValues, startOfLineIndex, mainAxis, crossAxis, measureModeMainDim, measureModeCrossDim, mainAxisownerSize, ownerWidth, availableInnerMainDim, availableInnerCrossDim, availableInnerWidth, performLayout, layoutContext);
            float containerCrossAxis = availableInnerCrossDim;
            if (measureModeCrossDim == YGMeasureMode.YGMeasureModeUndefined || measureModeCrossDim == YGMeasureMode.YGMeasureModeAtMost) {
                containerCrossAxis = GlobalMembers.YGNodeBoundAxis(node, crossAxis, collectedFlexItemsValues.crossDim + paddingAndBorderAxisCross, crossAxisownerSize, ownerWidth) - paddingAndBorderAxisCross;
            }
            if (!isNodeFlexWrap && measureModeCrossDim == YGMeasureMode.YGMeasureModeExactly) {
                collectedFlexItemsValues.crossDim = availableInnerCrossDim;
            }
            collectedFlexItemsValues.crossDim = GlobalMembers.YGNodeBoundAxis(node, crossAxis, collectedFlexItemsValues.crossDim + paddingAndBorderAxisCross, crossAxisownerSize, ownerWidth) - paddingAndBorderAxisCross;
            if (performLayout) {
                for (int i = startOfLineIndex; i < endOfLineIndex; ++i) {
                    YGNode child = node.getChild(i);
                    if (child.getStyle().display() == YGDisplay.YGDisplayNone) continue;
                    if (child.getStyle().positionType() == YGPositionType.YGPositionTypeAbsolute) {
                        boolean isChildLeadingPosDefined = child.isLeadingPositionDefined(crossAxis);
                        if (isChildLeadingPosDefined) {
                            child.setLayoutPosition(child.getLeadingPosition(crossAxis, availableInnerCrossDim).unwrap() + node.getLeadingBorder(crossAxis) + child.getLeadingMargin(crossAxis, availableInnerWidth).unwrap(), pos.get(crossAxis.getValue()).getValue());
                        }
                        if (isChildLeadingPosDefined && !GlobalMembers.YGFloatIsUndefined(child.getLayout().position.get(pos.get(crossAxis.getValue()).getValue()).floatValue())) continue;
                        child.setLayoutPosition(node.getLeadingBorder(crossAxis) + child.getLeadingMargin(crossAxis, availableInnerWidth).unwrap(), pos.get(crossAxis.getValue()).getValue());
                        continue;
                    }
                    float leadingCrossDim = leadingPaddingAndBorderCross;
                    YGAlign alignItem = GlobalMembers.YGNodeAlignItem(node, child);
                    if (alignItem == YGAlign.YGAlignStretch && child.marginLeadingValue((YGFlexDirection)crossAxis).unit != YGUnit.YGUnitAuto && child.marginTrailingValue((YGFlexDirection)crossAxis).unit != YGUnit.YGUnitAuto) {
                        if (!GlobalMembers.YGNodeIsStyleDimDefined(child, crossAxis, availableInnerCrossDim)) {
                            RefObject<Float> childMainSize = new RefObject<Float>(child.getLayout().measuredDimensions.get(dim.get(mainAxis.getValue()).getValue()));
                            YGStyle childStyle = child.getStyle();
                            RefObject<Float> childCrossSize = new RefObject<Float>(Float.valueOf(!childStyle.aspectRatio().isUndefined() ? child.getMarginForAxis(crossAxis, availableInnerWidth).unwrap() + (isMainAxisRow ? ((Float)childMainSize.argValue).floatValue() / childStyle.aspectRatio().unwrap() : ((Float)childMainSize.argValue).floatValue() * childStyle.aspectRatio().unwrap()) : collectedFlexItemsValues.crossDim));
                            RefObject<Float> refObject = childMainSize;
                            Float.valueOf(((Float)refObject.argValue).floatValue() + child.getMarginForAxis(mainAxis, availableInnerWidth).unwrap());
                            refObject.argValue = refObject.argValue;
                            GlobalMembers.YGConstrainMaxSizeForMode(child, mainAxis, availableInnerMainDim, availableInnerWidth, YGMeasureMode.YGMeasureModeExactly, childMainSize);
                            GlobalMembers.YGConstrainMaxSizeForMode(child, crossAxis, availableInnerCrossDim, availableInnerWidth, YGMeasureMode.YGMeasureModeExactly, childCrossSize);
                            childWidth = (isMainAxisRow ? (Float)childMainSize.argValue : (Float)childCrossSize.argValue).floatValue();
                            childHeight = (!isMainAxisRow ? (Float)childMainSize.argValue : (Float)childCrossSize.argValue).floatValue();
                            YGAlign alignContent = node.getStyle().alignContent();
                            boolean crossAxisDoesNotGrow = alignContent != YGAlign.YGAlignStretch && isNodeFlexWrap;
                            YGMeasureMode childWidthMeasureMode = GlobalMembers.YGFloatIsUndefined(childWidth) || !isMainAxisRow && crossAxisDoesNotGrow ? YGMeasureMode.YGMeasureModeUndefined : YGMeasureMode.YGMeasureModeExactly;
                            YGMeasureMode childHeightMeasureMode = GlobalMembers.YGFloatIsUndefined(childHeight) || isMainAxisRow && crossAxisDoesNotGrow ? YGMeasureMode.YGMeasureModeUndefined : YGMeasureMode.YGMeasureModeExactly;
                            GlobalMembers.YGLayoutNodeInternal(child, childWidth, childHeight, direction, childWidthMeasureMode, childHeightMeasureMode, availableInnerWidth, availableInnerHeight, true, LayoutPassReason.kStretch, config, layoutMarkerData, layoutContext, depth, generationCount);
                        }
                    } else {
                        float remainingCrossDim = containerCrossAxis - GlobalMembers.YGNodeDimWithMargin(child, crossAxis, availableInnerWidth);
                        if (child.marginLeadingValue((YGFlexDirection)crossAxis).unit == YGUnit.YGUnitAuto && child.marginTrailingValue((YGFlexDirection)crossAxis).unit == YGUnit.YGUnitAuto) {
                            leadingCrossDim += GlobalMembers.YGFloatMax(0.0f, remainingCrossDim / 2.0f);
                        } else if (child.marginTrailingValue((YGFlexDirection)crossAxis).unit != YGUnit.YGUnitAuto) {
                            if (child.marginLeadingValue((YGFlexDirection)crossAxis).unit == YGUnit.YGUnitAuto) {
                                leadingCrossDim += GlobalMembers.YGFloatMax(0.0f, remainingCrossDim);
                            } else if (alignItem != YGAlign.YGAlignFlexStart) {
                                leadingCrossDim = alignItem == YGAlign.YGAlignCenter ? (leadingCrossDim += remainingCrossDim / 2.0f) : (leadingCrossDim += remainingCrossDim);
                            }
                        }
                    }
                    child.setLayoutPosition(child.getLayout().position.get(pos.get(crossAxis.getValue()).getValue()).floatValue() + totalLineCrossDim + leadingCrossDim, pos.get(crossAxis.getValue()).getValue());
                }
            }
            totalLineCrossDim += collectedFlexItemsValues.crossDim;
            maxLineMainDim = GlobalMembers.YGFloatMax(maxLineMainDim, collectedFlexItemsValues.mainDim);
            ++lineCount;
            startOfLineIndex = endOfLineIndex;
        }
        if (performLayout && (isNodeFlexWrap || GlobalMembers.YGIsBaselineLayout(node))) {
            float crossDimLead = 0.0f;
            float currentLead = leadingPaddingAndBorderCross;
            if (!GlobalMembers.YGFloatIsUndefined(availableInnerCrossDim)) {
                float remainingAlignContentDim = availableInnerCrossDim - totalLineCrossDim;
                switch (node.getStyle().alignContent()) {
                    case YGAlignFlexEnd: {
                        currentLead += remainingAlignContentDim;
                        break;
                    }
                    case YGAlignCenter: {
                        currentLead += remainingAlignContentDim / 2.0f;
                        break;
                    }
                    case YGAlignStretch: {
                        if (!(availableInnerCrossDim > totalLineCrossDim)) break;
                        crossDimLead = remainingAlignContentDim / (float)lineCount;
                        break;
                    }
                    case YGAlignSpaceAround: {
                        if (availableInnerCrossDim > totalLineCrossDim) {
                            currentLead += remainingAlignContentDim / (float)(2 * lineCount);
                            if (lineCount <= 1) break;
                            crossDimLead = remainingAlignContentDim / (float)lineCount;
                            break;
                        }
                        currentLead += remainingAlignContentDim / 2.0f;
                        break;
                    }
                    case YGAlignSpaceBetween: {
                        if (!(availableInnerCrossDim > totalLineCrossDim) || lineCount <= 1) break;
                        crossDimLead = remainingAlignContentDim / (float)(lineCount - 1);
                        break;
                    }
                }
            }
            int endIndex = 0;
            for (int i = 0; i < lineCount; ++i) {
                YGNode child;
                int ii;
                int startIndex = endIndex;
                float lineHeight = 0.0f;
                float maxAscentForCurrentLine = 0.0f;
                float maxDescentForCurrentLine = 0.0f;
                for (ii = startIndex; ii < childCount; ++ii) {
                    child = node.getChild(ii);
                    if (child.getStyle().display() == YGDisplay.YGDisplayNone || child.getStyle().positionType() == YGPositionType.YGPositionTypeAbsolute) continue;
                    if (child.getLineIndex() != i) break;
                    if (GlobalMembers.YGNodeIsLayoutDimDefined(child, crossAxis)) {
                        lineHeight = GlobalMembers.YGFloatMax(lineHeight, child.getLayout().measuredDimensions.get(dim.get(crossAxis.getValue()).getValue()).floatValue() + child.getMarginForAxis(crossAxis, availableInnerWidth).unwrap());
                    }
                    if (GlobalMembers.YGNodeAlignItem(node, child) != YGAlign.YGAlignBaseline) continue;
                    float ascent = GlobalMembers.YGBaseline(child, layoutContext) + child.getLeadingMargin(YGFlexDirection.YGFlexDirectionColumn, availableInnerWidth).unwrap();
                    float descent = child.getLayout().measuredDimensions.get(YGDimension.YGDimensionHeight.getValue()).floatValue() + child.getMarginForAxis(YGFlexDirection.YGFlexDirectionColumn, availableInnerWidth).unwrap() - ascent;
                    maxAscentForCurrentLine = GlobalMembers.YGFloatMax(maxAscentForCurrentLine, ascent);
                    maxDescentForCurrentLine = GlobalMembers.YGFloatMax(maxDescentForCurrentLine, descent);
                    lineHeight = GlobalMembers.YGFloatMax(lineHeight, maxAscentForCurrentLine + maxDescentForCurrentLine);
                }
                endIndex = ii;
                lineHeight += crossDimLead;
                if (performLayout) {
                    block18: for (ii = startIndex; ii < endIndex; ++ii) {
                        child = node.getChild(ii);
                        if (child.getStyle().display() == YGDisplay.YGDisplayNone || child.getStyle().positionType() == YGPositionType.YGPositionTypeAbsolute) continue;
                        switch (GlobalMembers.YGNodeAlignItem(node, child)) {
                            case YGAlignFlexStart: {
                                child.setLayoutPosition(currentLead + child.getLeadingMargin(crossAxis, availableInnerWidth).unwrap(), pos.get(crossAxis.getValue()).getValue());
                                continue block18;
                            }
                            case YGAlignFlexEnd: {
                                child.setLayoutPosition(currentLead + lineHeight - child.getTrailingMargin(crossAxis, availableInnerWidth).unwrap() - child.getLayout().measuredDimensions.get(dim.get(crossAxis.getValue()).getValue()).floatValue(), pos.get(crossAxis.getValue()).getValue());
                                continue block18;
                            }
                            case YGAlignCenter: {
                                float childHeight2 = child.getLayout().measuredDimensions.get(dim.get(crossAxis.getValue()).getValue()).floatValue();
                                child.setLayoutPosition(currentLead + (lineHeight - childHeight2) / 2.0f, pos.get(crossAxis.getValue()).getValue());
                                continue block18;
                            }
                            case YGAlignStretch: {
                                child.setLayoutPosition(currentLead + child.getLeadingMargin(crossAxis, availableInnerWidth).unwrap(), pos.get(crossAxis.getValue()).getValue());
                                if (GlobalMembers.YGNodeIsStyleDimDefined(child, crossAxis, availableInnerCrossDim)) continue block18;
                                childWidth = isMainAxisRow ? child.getLayout().measuredDimensions.get(YGDimension.YGDimensionWidth.getValue()).floatValue() + child.getMarginForAxis(mainAxis, availableInnerWidth).unwrap() : lineHeight;
                                float f = childHeight = !isMainAxisRow ? child.getLayout().measuredDimensions.get(YGDimension.YGDimensionHeight.getValue()).floatValue() + child.getMarginForAxis(crossAxis, availableInnerWidth).unwrap() : lineHeight;
                                if (GlobalMembers.YGFloatsEqual(childWidth, child.getLayout().measuredDimensions.get(YGDimension.YGDimensionWidth.getValue()).floatValue()) && GlobalMembers.YGFloatsEqual(childHeight, child.getLayout().measuredDimensions.get(YGDimension.YGDimensionHeight.getValue()).floatValue())) continue block18;
                                GlobalMembers.YGLayoutNodeInternal(child, childWidth, childHeight, direction, YGMeasureMode.YGMeasureModeExactly, YGMeasureMode.YGMeasureModeExactly, availableInnerWidth, availableInnerHeight, true, LayoutPassReason.kMultilineStretch, config, layoutMarkerData, layoutContext, depth, generationCount);
                                continue block18;
                            }
                            case YGAlignBaseline: {
                                child.setLayoutPosition(currentLead + maxAscentForCurrentLine - GlobalMembers.YGBaseline(child, layoutContext) + child.getLeadingPosition(YGFlexDirection.YGFlexDirectionColumn, availableInnerCrossDim).unwrap(), YGEdge.YGEdgeTop.getValue());
                                continue block18;
                            }
                        }
                    }
                }
                currentLead += lineHeight;
            }
        }
        node.setLayoutMeasuredDimension(GlobalMembers.YGNodeBoundAxis(node, YGFlexDirection.YGFlexDirectionRow, availableWidth - marginAxisRow, ownerWidth, ownerWidth), YGDimension.YGDimensionWidth.getValue());
        node.setLayoutMeasuredDimension(GlobalMembers.YGNodeBoundAxis(node, YGFlexDirection.YGFlexDirectionColumn, availableHeight - marginAxisColumn, ownerHeight, ownerWidth), YGDimension.YGDimensionHeight.getValue());
        if (measureModeMainDim == YGMeasureMode.YGMeasureModeUndefined || node.getStyle().overflow() != YGOverflow.YGOverflowScroll && measureModeMainDim == YGMeasureMode.YGMeasureModeAtMost) {
            node.setLayoutMeasuredDimension(GlobalMembers.YGNodeBoundAxis(node, mainAxis, maxLineMainDim, mainAxisownerSize, ownerWidth), dim.get(mainAxis.getValue()).getValue());
        } else if (measureModeMainDim == YGMeasureMode.YGMeasureModeAtMost && node.getStyle().overflow() == YGOverflow.YGOverflowScroll) {
            node.setLayoutMeasuredDimension(GlobalMembers.YGFloatMax(GlobalMembers.YGFloatMin(availableInnerMainDim + paddingAndBorderAxisMain, GlobalMembers.YGNodeBoundAxisWithinMinAndMax(node, mainAxis, new YGFloatOptional(maxLineMainDim), mainAxisownerSize).unwrap()), paddingAndBorderAxisMain), dim.get(mainAxis.getValue()).getValue());
        }
        if (measureModeCrossDim == YGMeasureMode.YGMeasureModeUndefined || node.getStyle().overflow() != YGOverflow.YGOverflowScroll && measureModeCrossDim == YGMeasureMode.YGMeasureModeAtMost) {
            node.setLayoutMeasuredDimension(GlobalMembers.YGNodeBoundAxis(node, crossAxis, totalLineCrossDim + paddingAndBorderAxisCross, crossAxisownerSize, ownerWidth), dim.get(crossAxis.getValue()).getValue());
        } else if (measureModeCrossDim == YGMeasureMode.YGMeasureModeAtMost && node.getStyle().overflow() == YGOverflow.YGOverflowScroll) {
            node.setLayoutMeasuredDimension(GlobalMembers.YGFloatMax(GlobalMembers.YGFloatMin(availableInnerCrossDim + paddingAndBorderAxisCross, GlobalMembers.YGNodeBoundAxisWithinMinAndMax(node, crossAxis, new YGFloatOptional(totalLineCrossDim + paddingAndBorderAxisCross), crossAxisownerSize).unwrap()), paddingAndBorderAxisCross), dim.get(crossAxis.getValue()).getValue());
        }
        if (performLayout && node.getStyle().flexWrap() == YGWrap.YGWrapWrapReverse) {
            for (int i = 0; i < childCount; ++i) {
                YGNode child = GlobalMembers.YGNodeGetChild(node, i);
                if (child.getStyle().positionType() == YGPositionType.YGPositionTypeAbsolute) continue;
                child.setLayoutPosition(node.getLayout().measuredDimensions.get(dim.get(crossAxis.getValue()).getValue()).floatValue() - child.getLayout().position.get(pos.get(crossAxis.getValue()).getValue()).floatValue() - child.getLayout().measuredDimensions.get(dim.get(crossAxis.getValue()).getValue()).floatValue(), pos.get(crossAxis.getValue()).getValue());
            }
        }
        if (performLayout) {
            boolean needsCrossTrailingPos;
            for (YGNode child : node.getChildren()) {
                if (child.getStyle().display() == YGDisplay.YGDisplayNone || child.getStyle().positionType() != YGPositionType.YGPositionTypeAbsolute) continue;
                GlobalMembers.YGNodeAbsoluteLayoutChild(node, child, availableInnerWidth, isMainAxisRow ? measureModeMainDim : measureModeCrossDim, availableInnerHeight, direction, config, layoutMarkerData, layoutContext, depth, generationCount);
            }
            boolean needsMainTrailingPos = mainAxis == YGFlexDirection.YGFlexDirectionRowReverse || mainAxis == YGFlexDirection.YGFlexDirectionColumnReverse;
            boolean bl3 = needsCrossTrailingPos = crossAxis == YGFlexDirection.YGFlexDirectionRowReverse || crossAxis == YGFlexDirection.YGFlexDirectionColumnReverse;
            if (needsMainTrailingPos || needsCrossTrailingPos) {
                for (int i = 0; i < childCount; ++i) {
                    YGNode child = node.getChild(i);
                    if (child.getStyle().display() == YGDisplay.YGDisplayNone) continue;
                    if (needsMainTrailingPos) {
                        GlobalMembers.YGNodeSetChildTrailingPosition(node, child, mainAxis);
                    }
                    if (!needsCrossTrailingPos) continue;
                    GlobalMembers.YGNodeSetChildTrailingPosition(node, child, crossAxis);
                }
            }
        }
    }

    public static String YGSpacer(int level) {
        int spacerLen = spacer.length();
        if (level > spacerLen) {
            return spacer.substring(0, 0);
        }
        return spacer.substring(spacerLen - level);
    }

    public static String YGMeasureModeName(YGMeasureMode mode, boolean performLayout) {
        int N = 32;
        String[] kMeasureModeNames = new String[]{"UNDEFINED", "EXACTLY", "AT_MOST"};
        String[] kLayoutModeNames = new String[]{"LAY_UNDEFINED", "LAY_EXACTLY", "LAY_AT_MOST"};
        if (mode.getValue() >= N) {
            return "";
        }
        return performLayout ? kLayoutModeNames[mode.getValue()] : kMeasureModeNames[mode.getValue()];
    }

    public static boolean YGMeasureModeSizeIsExactAndMatchesOldMeasuredSize(YGMeasureMode sizeMode, float size, float lastComputedSize) {
        return sizeMode == YGMeasureMode.YGMeasureModeExactly && GlobalMembers.YGFloatsEqual(size, lastComputedSize);
    }

    public static boolean YGMeasureModeOldSizeIsUnspecifiedAndStillFits(YGMeasureMode sizeMode, float size, YGMeasureMode lastSizeMode, float lastComputedSize) {
        return sizeMode == YGMeasureMode.YGMeasureModeAtMost && lastSizeMode == YGMeasureMode.YGMeasureModeUndefined && (size >= lastComputedSize || GlobalMembers.YGFloatsEqual(size, lastComputedSize));
    }

    public static boolean YGMeasureModeNewMeasureSizeIsStricterAndStillValid(YGMeasureMode sizeMode, float size, YGMeasureMode lastSizeMode, float lastSize, float lastComputedSize) {
        return lastSizeMode == YGMeasureMode.YGMeasureModeAtMost && sizeMode == YGMeasureMode.YGMeasureModeAtMost && !GlobalMembers.YGFloatIsUndefined(lastSize) && !GlobalMembers.YGFloatIsUndefined(size) && !GlobalMembers.YGFloatIsUndefined(lastComputedSize) && lastSize > size && (lastComputedSize <= size || GlobalMembers.YGFloatsEqual(size, lastComputedSize));
    }

    public static void YGRoundToPixelGrid(YGNode node, double pointScaleFactor, double absoluteLeft, double absoluteTop) {
        if (pointScaleFactor == 0.0) {
            return;
        }
        double nodeLeft = node.getLayout().position.get(YGEdge.YGEdgeLeft.getValue()).floatValue();
        double nodeTop = node.getLayout().position.get(YGEdge.YGEdgeTop.getValue()).floatValue();
        double nodeWidth = node.getLayout().dimensions.get(YGDimension.YGDimensionWidth.getValue()).floatValue();
        double nodeHeight = node.getLayout().dimensions.get(YGDimension.YGDimensionHeight.getValue()).floatValue();
        double absoluteNodeLeft = absoluteLeft + nodeLeft;
        double absoluteNodeTop = absoluteTop + nodeTop;
        double absoluteNodeRight = absoluteNodeLeft + nodeWidth;
        double absoluteNodeBottom = absoluteNodeTop + nodeHeight;
        boolean textRounding = node.getNodeType() == YGNodeType.YGNodeTypeText;
        node.setLayoutPosition(GlobalMembers.YGRoundValueToPixelGrid(nodeLeft, pointScaleFactor, false, textRounding), YGEdge.YGEdgeLeft.getValue());
        node.setLayoutPosition(GlobalMembers.YGRoundValueToPixelGrid(nodeTop, pointScaleFactor, false, textRounding), YGEdge.YGEdgeTop.getValue());
        boolean hasFractionalWidth = !GlobalMembers.YGDoubleEqual(nodeWidth * pointScaleFactor % 1.0, 0.0) && !GlobalMembers.YGDoubleEqual(nodeWidth * pointScaleFactor % 1.0, 1.0);
        boolean hasFractionalHeight = !GlobalMembers.YGDoubleEqual(nodeHeight * pointScaleFactor % 1.0, 0.0) && !GlobalMembers.YGDoubleEqual(nodeHeight * pointScaleFactor % 1.0, 1.0);
        node.setLayoutDimension(GlobalMembers.YGRoundValueToPixelGrid(absoluteNodeRight, pointScaleFactor, textRounding && hasFractionalWidth, textRounding && !hasFractionalWidth) - GlobalMembers.YGRoundValueToPixelGrid(absoluteNodeLeft, pointScaleFactor, false, textRounding), YGDimension.YGDimensionWidth.getValue());
        node.setLayoutDimension(GlobalMembers.YGRoundValueToPixelGrid(absoluteNodeBottom, pointScaleFactor, textRounding && hasFractionalHeight, textRounding && !hasFractionalHeight) - GlobalMembers.YGRoundValueToPixelGrid(absoluteNodeTop, pointScaleFactor, false, textRounding), YGDimension.YGDimensionHeight.getValue());
        Integer childCount = GlobalMembers.YGNodeGetChildCount(node);
        Integer i = 0;
        while (i < childCount) {
            GlobalMembers.YGRoundToPixelGrid(GlobalMembers.YGNodeGetChild(node, i), pointScaleFactor, absoluteNodeLeft, absoluteNodeTop);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public static void unsetUseLegacyFlagRecursively(YGNode node) {
        if (node.getConfig() != null) {
            node.getConfig().useLegacyStretchBehaviour = false;
        }
        for (YGNode child : node.getChildren()) {
            GlobalMembers.unsetUseLegacyFlagRecursively(child);
        }
    }

    public static void YGNodeCalculateLayoutWithContext(YGNode node, float ownerWidth, float ownerHeight, YGDirection ownerDirection, Object layoutContext) {
        YGMeasureMode heightMeasureMode;
        float height;
        YGMeasureMode widthMeasureMode;
        float width;
        Event.publish(node, new LayoutPassStartEventData(layoutContext));
        LayoutData markerData = new LayoutData();
        gCurrentGenerationCount.incrementAndGet();
        node.resolveDimension();
        Values<YGDimension> maxDimensions = node.getStyle().maxDimensions();
        if (GlobalMembers.YGNodeIsStyleDimDefined(node, YGFlexDirection.YGFlexDirectionRow, ownerWidth)) {
            width = GlobalMembers.YGResolveValue(node.getResolvedDimension(dim.get(YGFlexDirection.YGFlexDirectionRow.getValue()).getValue()), ownerWidth).unwrap() + node.getMarginForAxis(YGFlexDirection.YGFlexDirectionRow, ownerWidth).unwrap();
            widthMeasureMode = YGMeasureMode.YGMeasureModeExactly;
        } else if (!GlobalMembers.YGResolveValue(maxDimensions.get(YGDimension.YGDimensionWidth.getValue()), ownerWidth).isUndefined()) {
            width = GlobalMembers.YGResolveValue(maxDimensions.get(YGDimension.YGDimensionWidth.getValue()), ownerWidth).unwrap();
            widthMeasureMode = YGMeasureMode.YGMeasureModeAtMost;
        } else {
            width = ownerWidth;
            YGMeasureMode yGMeasureMode = widthMeasureMode = GlobalMembers.YGFloatIsUndefined(width) ? YGMeasureMode.YGMeasureModeUndefined : YGMeasureMode.YGMeasureModeExactly;
        }
        if (GlobalMembers.YGNodeIsStyleDimDefined(node, YGFlexDirection.YGFlexDirectionColumn, ownerHeight)) {
            height = GlobalMembers.YGResolveValue(node.getResolvedDimension(dim.get(YGFlexDirection.YGFlexDirectionColumn.getValue()).getValue()), ownerHeight).unwrap() + node.getMarginForAxis(YGFlexDirection.YGFlexDirectionColumn, ownerWidth).unwrap();
            heightMeasureMode = YGMeasureMode.YGMeasureModeExactly;
        } else if (!GlobalMembers.YGResolveValue(maxDimensions.get(YGDimension.YGDimensionHeight.getValue()), ownerHeight).isUndefined()) {
            height = GlobalMembers.YGResolveValue(maxDimensions.get(YGDimension.YGDimensionHeight.getValue()), ownerHeight).unwrap();
            heightMeasureMode = YGMeasureMode.YGMeasureModeAtMost;
        } else {
            height = ownerHeight;
            YGMeasureMode yGMeasureMode = heightMeasureMode = GlobalMembers.YGFloatIsUndefined(height) ? YGMeasureMode.YGMeasureModeUndefined : YGMeasureMode.YGMeasureModeExactly;
        }
        if (GlobalMembers.YGLayoutNodeInternal(node, width, height, ownerDirection, widthMeasureMode, heightMeasureMode, ownerWidth, ownerHeight, true, LayoutPassReason.kInitial, node.getConfig(), markerData, layoutContext, 0, gCurrentGenerationCount.get())) {
            node.setPosition(node.getLayout().direction(), ownerWidth, ownerHeight, ownerWidth);
            if (node.getConfig() != null) {
                GlobalMembers.YGRoundToPixelGrid(node, node.getConfig().pointScaleFactor, 0.0, 0.0);
            }
        }
        Event.publish(node, new LayoutPassEndEventData(layoutContext, markerData));
        if (node.getConfig() != null && node.getConfig().shouldDiffLayoutWithoutLegacyStretchBehaviour && node.didUseLegacyFlag()) {
            YGNode nodeWithoutLegacyFlag = GlobalMembers.YGNodeDeepClone(node);
            nodeWithoutLegacyFlag.resolveDimension();
            nodeWithoutLegacyFlag.markDirtyAndPropogateDownwards();
            gCurrentGenerationCount.incrementAndGet();
            GlobalMembers.unsetUseLegacyFlagRecursively(nodeWithoutLegacyFlag);
            LayoutData layoutMarkerData = new LayoutData();
            if (GlobalMembers.YGLayoutNodeInternal(nodeWithoutLegacyFlag, width, height, ownerDirection, widthMeasureMode, heightMeasureMode, ownerWidth, ownerHeight, true, LayoutPassReason.kInitial, nodeWithoutLegacyFlag.getConfig(), layoutMarkerData, layoutContext, 0, gCurrentGenerationCount.get())) {
                nodeWithoutLegacyFlag.setPosition(nodeWithoutLegacyFlag.getLayout().direction(), ownerWidth, ownerHeight, ownerWidth);
                GlobalMembers.YGRoundToPixelGrid(nodeWithoutLegacyFlag, nodeWithoutLegacyFlag.getConfig().pointScaleFactor, 0.0, 0.0);
                boolean neededLegacyStretchBehaviour = !nodeWithoutLegacyFlag.isLayoutTreeEqualToNode(node);
                node.setLayoutDoesLegacyFlagAffectsLayout(neededLegacyStretchBehaviour);
            }
            GlobalMembers.YGConfigFreeRecursive(nodeWithoutLegacyFlag);
            GlobalMembers.YGNodeFreeRecursive(nodeWithoutLegacyFlag);
        }
    }

    public static void YGTraverseChildrenPreOrder(ArrayList<YGNode> children, NodeTraverseDelegate f) {
        for (YGNode node : children) {
            f.invoke(node);
            GlobalMembers.YGTraverseChildrenPreOrder(node.getChildren(), f);
        }
    }

    public static void YGTraversePreOrder(YGNode node, NodeTraverseDelegate f) {
        if (node == null) {
            return;
        }
        f.invoke(node);
        GlobalMembers.YGTraverseChildrenPreOrder(node.getChildren(), f);
    }

    public static YGFloatOptional plus(YGFloatOptional lhs, YGFloatOptional rhs) {
        return new YGFloatOptional(lhs.unwrap() + rhs.unwrap());
    }

    public static boolean greaterThan(YGFloatOptional lhs, YGFloatOptional rhs) {
        return lhs.unwrap() > rhs.unwrap();
    }

    public static boolean lessThan(YGFloatOptional lhs, YGFloatOptional rhs) {
        return lhs.unwrap() < rhs.unwrap();
    }

    public static boolean greaterThanOrEqualTo(YGFloatOptional lhs, YGFloatOptional rhs) {
        return lhs.unwrap() > rhs.unwrap() || lhs.unwrap() == rhs.unwrap();
    }

    public static boolean lessThanOrEqualTo(YGFloatOptional lhs, YGFloatOptional rhs) {
        return lhs.unwrap() < rhs.unwrap() || lhs.unwrap() == rhs.unwrap();
    }

    static {
        ArrayList<YGEdge> ygEdges = new ArrayList<YGEdge>();
        ygEdges.add(YGEdge.YGEdgeTop);
        ygEdges.add(YGEdge.YGEdgeBottom);
        ygEdges.add(YGEdge.YGEdgeLeft);
        ygEdges.add(YGEdge.YGEdgeRight);
        leading = new ArrayList(ygEdges);
        ygEdges = new ArrayList();
        ygEdges.add(YGEdge.YGEdgeBottom);
        ygEdges.add(YGEdge.YGEdgeTop);
        ygEdges.add(YGEdge.YGEdgeRight);
        ygEdges.add(YGEdge.YGEdgeLeft);
        trailing = new ArrayList(ygEdges);
        ygEdges = new ArrayList();
        ygEdges.add(YGEdge.YGEdgeTop);
        ygEdges.add(YGEdge.YGEdgeBottom);
        ygEdges.add(YGEdge.YGEdgeLeft);
        ygEdges.add(YGEdge.YGEdgeRight);
        pos = new ArrayList(ygEdges);
        ArrayList<YGDimension> ygDimensions = new ArrayList<YGDimension>();
        ygDimensions.add(YGDimension.YGDimensionHeight);
        ygDimensions.add(YGDimension.YGDimensionHeight);
        ygDimensions.add(YGDimension.YGDimensionWidth);
        ygDimensions.add(YGDimension.YGDimensionWidth);
        dim = new ArrayList(ygDimensions);
        defaultConfig = GlobalMembers.YGConfigNew();
        gCurrentGenerationCount = new AtomicInteger();
        gConfigInstanceCount = 0;
    }

    @FunctionalInterface
    static interface NodeTraverseDelegate {
        public void invoke(YGNode var1);
    }
}

