/*
 * Decompiled with CFR 0.152.
 */
package io.github.orioncraftmc.meditate.internal;

import io.github.orioncraftmc.meditate.internal.YGConfig;
import io.github.orioncraftmc.meditate.internal.YGFloatOptional;
import io.github.orioncraftmc.meditate.internal.YGLayout;
import io.github.orioncraftmc.meditate.internal.YGSize;
import io.github.orioncraftmc.meditate.internal.YGStyle;
import io.github.orioncraftmc.meditate.internal.YGValue;
import io.github.orioncraftmc.meditate.internal.detail.CompactValue;
import io.github.orioncraftmc.meditate.internal.detail.GlobalMembers;
import io.github.orioncraftmc.meditate.internal.detail.Values;
import io.github.orioncraftmc.meditate.internal.enums.YGAlign;
import io.github.orioncraftmc.meditate.internal.enums.YGDimension;
import io.github.orioncraftmc.meditate.internal.enums.YGDirection;
import io.github.orioncraftmc.meditate.internal.enums.YGEdge;
import io.github.orioncraftmc.meditate.internal.enums.YGFlexDirection;
import io.github.orioncraftmc.meditate.internal.enums.YGMeasureMode;
import io.github.orioncraftmc.meditate.internal.enums.YGNodeType;
import io.github.orioncraftmc.meditate.internal.enums.YGPositionType;
import io.github.orioncraftmc.meditate.internal.enums.YGUnit;
import io.github.orioncraftmc.meditate.internal.interfaces.BaselineWithContextFn;
import io.github.orioncraftmc.meditate.internal.interfaces.MeasureWithContextFn;
import io.github.orioncraftmc.meditate.internal.interfaces.PrintWithContextFn;
import io.github.orioncraftmc.meditate.internal.interfaces.YGBaselineFunc;
import io.github.orioncraftmc.meditate.internal.interfaces.YGDirtiedFunc;
import io.github.orioncraftmc.meditate.internal.interfaces.YGMeasureFunc;
import io.github.orioncraftmc.meditate.internal.interfaces.YGPrintFunc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class YGNode {
    private static final int hasNewLayout_ = 0;
    private static final int isReferenceBaseline_ = 1;
    private static final int isDirty_ = 2;
    private static final int nodeType_ = 3;
    private static final int measureUsesContext_ = 4;
    private static final int baselineUsesContext_ = 5;
    private static final int printUsesContext_ = 6;
    private static final int useWebDefaults_ = 7;
    private Object context_ = null;
    private Map<Object, Object> flags = new HashMap<Object, Object>();
    private byte reserved_ = 0;
    private measure_Struct measure_ = new measure_Struct();
    private baseline_Struct baseline_ = new baseline_Struct();
    private print_Struct print_ = new print_Struct();
    private YGDirtiedFunc dirtied_ = null;
    private YGStyle style_ = new YGStyle();
    private YGLayout layout_ = new YGLayout();
    private int lineIndex_ = 0;
    private YGNode owner_ = null;
    private ArrayList<YGNode> children_ = new ArrayList();
    private YGConfig config_ = new YGConfig(null);
    private ArrayList<YGValue> resolvedDimensions_ = new ArrayList<YGValue>(Arrays.asList(io.github.orioncraftmc.meditate.internal.GlobalMembers.YGValueUndefined, io.github.orioncraftmc.meditate.internal.GlobalMembers.YGValueUndefined));

    public YGNode(YGNode node) {
        this.context_ = node.context_;
        this.flags = node.flags;
        this.measure_ = node.measure_;
        this.baseline_ = node.baseline_;
        this.print_ = node.print_;
        this.dirtied_ = node.dirtied_;
        this.style_ = node.style_;
        this.layout_ = node.layout_;
        this.lineIndex_ = node.lineIndex_;
        this.owner_ = node.owner_;
        this.children_ = node.children_;
        this.config_ = node.config_;
        this.resolvedDimensions_ = node.resolvedDimensions_;
        for (YGNode c : this.children_) {
            c.setOwner(this);
        }
    }

    public YGNode(YGNode node, YGConfig config) {
        this(node);
        this.config_ = config;
        if (config.useWebDefaults) {
            this.useWebDefaults();
        }
    }

    public YGNode(YGConfig config) {
        this.config_ = config;
        if (config.useWebDefaults) {
            this.useWebDefaults();
        }
    }

    public static CompactValue computeEdgeValueForRow(Values<YGEdge> edges, YGEdge rowEdge, YGEdge edge, CompactValue defaultValue) {
        if (!edges.getCompactValue(rowEdge).isUndefined()) {
            return edges.getCompactValue(rowEdge);
        }
        if (!edges.getCompactValue(edge).isUndefined()) {
            return edges.getCompactValue(edge);
        }
        if (!edges.getCompactValue(YGEdge.YGEdgeHorizontal).isUndefined()) {
            return edges.getCompactValue(YGEdge.YGEdgeHorizontal);
        }
        if (!edges.getCompactValue(YGEdge.YGEdgeAll).isUndefined()) {
            return edges.getCompactValue(YGEdge.YGEdgeAll);
        }
        return defaultValue;
    }

    public static CompactValue computeEdgeValueForColumn(Values<YGEdge> edges, YGEdge edge, CompactValue defaultValue) {
        if (!edges.getCompactValue(edge).isUndefined()) {
            return edges.getCompactValue(edge);
        }
        if (!edges.getCompactValue(YGEdge.YGEdgeVertical).isUndefined()) {
            return edges.getCompactValue(YGEdge.YGEdgeVertical);
        }
        if (!edges.getCompactValue(YGEdge.YGEdgeAll).isUndefined()) {
            return edges.getCompactValue(YGEdge.YGEdgeAll);
        }
        return defaultValue;
    }

    public final YGValue getResolvedDimension(int index) {
        return this.resolvedDimensions_.get(index);
    }

    public final boolean isDirty() {
        return GlobalMembers.getBooleanData(this.flags, 2);
    }

    public void setDirty(boolean isDirty) {
        if (isDirty == GlobalMembers.getBooleanData(this.flags, 2)) {
            return;
        }
        GlobalMembers.setBooleanData(this.flags, 2, isDirty);
        if (isDirty && this.dirtied_ != null) {
            this.dirtied_.invoke(this);
        }
    }

    public final boolean hasBaselineFunc() {
        if (this.baseline_ != null) {
            return this.baseline_.noContext != null;
        }
        return false;
    }

    public final void setBaselineFunc(YGBaselineFunc baseLineFunc) {
        GlobalMembers.setBooleanData(this.flags, 5, false);
        if (this.baseline_ != null) {
            this.baseline_.noContext = baseLineFunc;
        }
    }

    public final void setBaselineFunc(BaselineWithContextFn baseLineFunc) {
        GlobalMembers.setBooleanData(this.flags, 5, true);
        if (this.baseline_ != null) {
            this.baseline_.withContext = baseLineFunc;
        }
    }

    public final void resetBaselineFunc() {
        GlobalMembers.setBooleanData(this.flags, 5, false);
        if (this.baseline_ != null) {
            this.baseline_.noContext = null;
        }
    }

    public final void setDirtiedFunc(YGDirtiedFunc dirtiedFunc) {
        this.dirtied_ = dirtiedFunc;
    }

    public final void setPrintFunc(YGPrintFunc printFunc) {
        if (this.print_ != null) {
            this.print_.noContext = printFunc;
        }
        GlobalMembers.setBooleanData(this.flags, 6, false);
    }

    public final void setPrintFunc(PrintWithContextFn printFunc) {
        if (this.print_ != null) {
            this.print_.withContext = printFunc;
        }
        GlobalMembers.setBooleanData(this.flags, 6, true);
    }

    public final void resetPrintFunc() {
        if (this.print_ != null) {
            this.print_.noContext = null;
        }
        GlobalMembers.setBooleanData(this.flags, 6, false);
    }

    public final boolean getHasNewLayout() {
        return GlobalMembers.getBooleanData(this.flags, 0);
    }

    public final void setHasNewLayout(boolean hasNewLayout) {
        GlobalMembers.setBooleanData(this.flags, 0, hasNewLayout);
    }

    public final YGNodeType getNodeType() {
        return GlobalMembers.getEnumData(YGNodeType.class, this.flags, 3);
    }

    public final void setNodeType(YGNodeType nodeType) {
        GlobalMembers.setEnumData(YGNodeType.class, this.flags, 3, nodeType);
    }

    public final void setIsReferenceBaseline(boolean isReferenceBaseline) {
        GlobalMembers.setBooleanData(this.flags, 1, isReferenceBaseline);
    }

    public final boolean isReferenceBaseline() {
        return GlobalMembers.getBooleanData(this.flags, 1);
    }

    public final YGNode getChild(Integer index) {
        return this.children_.get(index);
    }

    public final boolean hasMeasureFunc() {
        if (this.measure_ != null) {
            return this.measure_.noContext != null;
        }
        return false;
    }

    private void useWebDefaults() {
        GlobalMembers.setBooleanData(this.flags, 7, true);
        this.style_.flexDirectionBitfieldRef().setValue(YGFlexDirection.YGFlexDirectionRow);
        this.style_.alignContentBitfieldRef().setValue(YGAlign.YGAlignStretch);
    }

    public void print(Object printContext) {
        if (this.print_.noContext != null) {
            if (GlobalMembers.getBooleanData(this.flags, 6)) {
                this.print_.withContext.invoke(this, printContext);
            } else {
                this.print_.noContext.invoke(this);
            }
        }
    }

    public YGFloatOptional getLeadingPosition(YGFlexDirection axis, float axisSize) {
        CompactValue leadingPosition = io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFlexDirectionIsRow(axis) ? YGNode.computeEdgeValueForRow(this.style_.position(), YGEdge.YGEdgeStart, io.github.orioncraftmc.meditate.internal.GlobalMembers.leading.get(axis.getValue()), CompactValue.ofZero()) : YGNode.computeEdgeValueForColumn(this.style_.position(), io.github.orioncraftmc.meditate.internal.GlobalMembers.leading.get(axis.getValue()), CompactValue.ofZero());
        return io.github.orioncraftmc.meditate.internal.GlobalMembers.YGResolveValue(leadingPosition, axisSize);
    }

    public YGFloatOptional getTrailingPosition(YGFlexDirection axis, float axisSize) {
        CompactValue trailingPosition = io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFlexDirectionIsRow(axis) ? YGNode.computeEdgeValueForRow(this.style_.position(), YGEdge.YGEdgeEnd, io.github.orioncraftmc.meditate.internal.GlobalMembers.trailing.get(axis.getValue()), CompactValue.ofZero()) : YGNode.computeEdgeValueForColumn(this.style_.position(), io.github.orioncraftmc.meditate.internal.GlobalMembers.trailing.get(axis.getValue()), CompactValue.ofZero());
        return io.github.orioncraftmc.meditate.internal.GlobalMembers.YGResolveValue(trailingPosition, axisSize);
    }

    public boolean isLeadingPositionDefined(YGFlexDirection axis) {
        CompactValue leadingPosition = io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFlexDirectionIsRow(axis) ? YGNode.computeEdgeValueForRow(this.style_.position(), YGEdge.YGEdgeStart, io.github.orioncraftmc.meditate.internal.GlobalMembers.leading.get(axis.getValue()), CompactValue.ofUndefined()) : YGNode.computeEdgeValueForColumn(this.style_.position(), io.github.orioncraftmc.meditate.internal.GlobalMembers.leading.get(axis.getValue()), CompactValue.ofUndefined());
        return !leadingPosition.isUndefined();
    }

    public boolean isTrailingPosDefined(YGFlexDirection axis) {
        CompactValue trailingPosition = io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFlexDirectionIsRow(axis) ? YGNode.computeEdgeValueForRow(this.style_.position(), YGEdge.YGEdgeEnd, io.github.orioncraftmc.meditate.internal.GlobalMembers.trailing.get(axis.getValue()), CompactValue.ofUndefined()) : YGNode.computeEdgeValueForColumn(this.style_.position(), io.github.orioncraftmc.meditate.internal.GlobalMembers.trailing.get(axis.getValue()), CompactValue.ofUndefined());
        return !trailingPosition.isUndefined();
    }

    public YGFloatOptional getLeadingMargin(YGFlexDirection axis, float widthSize) {
        CompactValue leadingMargin = io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFlexDirectionIsRow(axis) ? YGNode.computeEdgeValueForRow(this.style_.margin(), YGEdge.YGEdgeStart, io.github.orioncraftmc.meditate.internal.GlobalMembers.leading.get(axis.getValue()), CompactValue.ofZero()) : YGNode.computeEdgeValueForColumn(this.style_.margin(), io.github.orioncraftmc.meditate.internal.GlobalMembers.leading.get(axis.getValue()), CompactValue.ofZero());
        return io.github.orioncraftmc.meditate.internal.GlobalMembers.YGResolveValueMargin(leadingMargin, widthSize);
    }

    public YGFloatOptional getTrailingMargin(YGFlexDirection axis, float widthSize) {
        CompactValue trailingMargin = io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFlexDirectionIsRow(axis) ? YGNode.computeEdgeValueForRow(this.style_.margin(), YGEdge.YGEdgeEnd, io.github.orioncraftmc.meditate.internal.GlobalMembers.trailing.get(axis.getValue()), CompactValue.ofZero()) : YGNode.computeEdgeValueForColumn(this.style_.margin(), io.github.orioncraftmc.meditate.internal.GlobalMembers.trailing.get(axis.getValue()), CompactValue.ofZero());
        return io.github.orioncraftmc.meditate.internal.GlobalMembers.YGResolveValueMargin(trailingMargin, widthSize);
    }

    public YGFloatOptional getMarginForAxis(YGFlexDirection axis, float widthSize) {
        return io.github.orioncraftmc.meditate.internal.GlobalMembers.plus(this.getLeadingMargin(axis, widthSize), this.getTrailingMargin(axis, widthSize));
    }

    public YGSize measure(float width, YGMeasureMode widthMode, float height, YGMeasureMode heightMode, Object layoutContext) {
        return GlobalMembers.getBooleanData(this.flags, 4) ? this.measure_.withContext.invoke(this, width, widthMode, height, heightMode, layoutContext) : this.measure_.noContext.invoke(this, width, widthMode, height, heightMode);
    }

    public float baseline(float width, float height, Object layoutContext) {
        return GlobalMembers.getBooleanData(this.flags, 5) ? this.baseline_.withContext.invoke(this, width, height, layoutContext) : this.baseline_.noContext.invoke(this, width, height);
    }

    public void setMeasureFunc(measure_Struct measureFunc) {
        if (measureFunc.noContext == null) {
            this.setNodeType(YGNodeType.YGNodeTypeDefault);
        } else {
            io.github.orioncraftmc.meditate.internal.GlobalMembers.YGAssertWithNode(this, this.children_.size() == 0, "Cannot set measure function: Nodes with measure functions cannot have children.");
            this.setNodeType(YGNodeType.YGNodeTypeText);
        }
        this.measure_ = measureFunc;
    }

    public void setMeasureFunc(YGMeasureFunc measureFunc) {
        GlobalMembers.setBooleanData(this.flags, 4, false);
        this.measure_.noContext = measureFunc;
        this.setMeasureFunc(this.measure_);
    }

    public void setMeasureFunc(MeasureWithContextFn measureFunc) {
        GlobalMembers.setBooleanData(this.flags, 4, true);
        this.measure_.withContext = measureFunc;
        this.setMeasureFunc(this.measure_);
    }

    public void replaceChild(YGNode child, Integer index) {
        this.children_.set(index, child);
    }

    public void replaceChild(YGNode oldChild, YGNode newChild) {
        this.children_.replaceAll(ygNode -> ygNode.equals(oldChild) ? newChild : ygNode);
    }

    public void insertChild(YGNode child, Integer index) {
        this.children_.add(index, child);
    }

    public boolean removeChild(YGNode child) {
        return this.children_.remove(child);
    }

    public void removeChild(int index) {
        this.children_.remove(index);
    }

    public void setLayoutDirection(YGDirection direction) {
        this.layout_.setDirection(direction);
    }

    public void setLayoutMargin(float margin, int index) {
        this.layout_.margin.set(index, Float.valueOf(margin));
    }

    public void setLayoutBorder(float border, int index) {
        this.layout_.border.set(index, Float.valueOf(border));
    }

    public void setLayoutPadding(float padding, int index) {
        this.layout_.padding.set(index, Float.valueOf(padding));
    }

    public void setLayoutLastOwnerDirection(YGDirection direction) {
        this.layout_.lastOwnerDirection = direction;
    }

    public void setLayoutComputedFlexBasis(YGFloatOptional computedFlexBasis) {
        if (this.layout_ != null) {
            this.layout_.computedFlexBasis = computedFlexBasis;
        }
    }

    public void setLayoutPosition(float position, int index) {
        this.layout_.position.set(index, Float.valueOf(position));
    }

    public void setLayoutComputedFlexBasisGeneration(Integer computedFlexBasisGeneration) {
        this.layout_.computedFlexBasisGeneration = computedFlexBasisGeneration;
    }

    public void setLayoutMeasuredDimension(float measuredDimension, int index) {
        this.layout_.measuredDimensions.set(index, Float.valueOf(measuredDimension));
    }

    public void setLayoutHadOverflow(boolean hadOverflow) {
        this.layout_.setHadOverflow(hadOverflow);
    }

    public void setLayoutDimension(float dimension, int index) {
        this.layout_.dimensions.set(index, Float.valueOf(dimension));
    }

    public YGFloatOptional relativePosition(YGFlexDirection axis, float axisSize) {
        if (this.isLeadingPositionDefined(axis)) {
            return this.getLeadingPosition(axis, axisSize);
        }
        YGFloatOptional trailingPosition = this.getTrailingPosition(axis, axisSize);
        if (!trailingPosition.isUndefined()) {
            trailingPosition = new YGFloatOptional(-1.0f * trailingPosition.unwrap());
        }
        return trailingPosition;
    }

    public void setPosition(YGDirection direction, float mainSize, float crossSize, float ownerWidth) {
        YGDirection directionRespectingRoot = this.owner_ != null ? direction : YGDirection.YGDirectionLTR;
        YGFlexDirection mainAxis = io.github.orioncraftmc.meditate.internal.GlobalMembers.YGResolveFlexDirection(this.style_.flexDirection(), directionRespectingRoot);
        YGFlexDirection crossAxis = io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFlexDirectionCross(mainAxis, directionRespectingRoot);
        YGFloatOptional relativePositionMain = this.relativePosition(mainAxis, mainSize);
        YGFloatOptional relativePositionCross = this.relativePosition(crossAxis, crossSize);
        this.setLayoutPosition(io.github.orioncraftmc.meditate.internal.GlobalMembers.plus(this.getLeadingMargin(mainAxis, ownerWidth), relativePositionMain).unwrap(), io.github.orioncraftmc.meditate.internal.GlobalMembers.leading.get(mainAxis.getValue()).getValue());
        this.setLayoutPosition(io.github.orioncraftmc.meditate.internal.GlobalMembers.plus(this.getTrailingMargin(mainAxis, ownerWidth), relativePositionMain).unwrap(), io.github.orioncraftmc.meditate.internal.GlobalMembers.trailing.get(mainAxis.getValue()).getValue());
        this.setLayoutPosition(io.github.orioncraftmc.meditate.internal.GlobalMembers.plus(this.getLeadingMargin(crossAxis, ownerWidth), relativePositionCross).unwrap(), io.github.orioncraftmc.meditate.internal.GlobalMembers.leading.get(crossAxis.getValue()).getValue());
        this.setLayoutPosition(io.github.orioncraftmc.meditate.internal.GlobalMembers.plus(this.getTrailingMargin(crossAxis, ownerWidth), relativePositionCross).unwrap(), io.github.orioncraftmc.meditate.internal.GlobalMembers.trailing.get(crossAxis.getValue()).getValue());
    }

    public YGValue marginLeadingValue(YGFlexDirection axis) {
        if (io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFlexDirectionIsRow(axis) && !this.style_.margin().getCompactValue(YGEdge.YGEdgeStart).isUndefined()) {
            return this.style_.margin().get(YGEdge.YGEdgeStart.getValue());
        }
        return this.style_.margin().get(io.github.orioncraftmc.meditate.internal.GlobalMembers.leading.get(axis.getValue()).getValue());
    }

    public YGValue marginTrailingValue(YGFlexDirection axis) {
        if (io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFlexDirectionIsRow(axis) && !this.style_.margin().getCompactValue(YGEdge.YGEdgeEnd).isUndefined()) {
            return this.style_.margin().get(YGEdge.YGEdgeEnd.getValue());
        }
        return this.style_.margin().get(io.github.orioncraftmc.meditate.internal.GlobalMembers.trailing.get(axis.getValue()).getValue());
    }

    public YGValue resolveFlexBasisPtr() {
        YGValue flexBasis = this.style_.flexBasis().convertToYgValue();
        if (flexBasis.unit != YGUnit.YGUnitAuto && flexBasis.unit != YGUnit.YGUnitUndefined) {
            return flexBasis;
        }
        if (!this.style_.flex().isUndefined() && this.style_.flex().unwrap() > 0.0f) {
            return GlobalMembers.getBooleanData(this.flags, 7) ? io.github.orioncraftmc.meditate.internal.GlobalMembers.YGValueAuto : io.github.orioncraftmc.meditate.internal.GlobalMembers.YGValueZero;
        }
        return io.github.orioncraftmc.meditate.internal.GlobalMembers.YGValueAuto;
    }

    public void resolveDimension() {
        YGDimension[] dimensions;
        YGStyle style = this.getStyle();
        for (YGDimension dim : dimensions = new YGDimension[]{YGDimension.YGDimensionWidth, YGDimension.YGDimensionHeight}) {
            if (!style.maxDimensions().getCompactValue(dim.getValue()).isUndefined() && io.github.orioncraftmc.meditate.internal.GlobalMembers.YGValueEqual(style.maxDimensions().getCompactValue(dim.getValue()), style.minDimensions().getCompactValue(dim.getValue()))) {
                this.resolvedDimensions_.set(dim.getValue(), style.maxDimensions().get(dim.getValue()));
                continue;
            }
            this.resolvedDimensions_.set(dim.getValue(), style.dimensions().get(dim.getValue()));
        }
    }

    public YGDirection resolveDirection(YGDirection ownerDirection) {
        if (this.style_.direction() == YGDirection.YGDirectionInherit) {
            return ownerDirection.getValue() > YGDirection.YGDirectionInherit.getValue() ? ownerDirection : YGDirection.YGDirectionLTR;
        }
        return this.style_.direction();
    }

    public void clearChildren() {
        this.children_.clear();
    }

    public void cloneChildrenIfNeeded(Object cloneContext) {
        this.iterChildrenAfterCloningIfNeeded((UnnamedParameter, UnnamedParameter2) -> {}, cloneContext);
    }

    public final <T> void iterChildrenAfterCloningIfNeeded(BiConsumer<YGNode, Object> callback, Object cloneContext) {
        int i = 0;
        for (YGNode child : this.children_) {
            if (child.getOwner() != this) {
                child = this.config_.cloneNode(child, this, i, cloneContext);
                child.setOwner(this);
            }
            ++i;
            callback.accept(child, cloneContext);
        }
    }

    public void markDirtyAndPropogate() {
        if (!GlobalMembers.getBooleanData(this.flags, 2)) {
            this.setDirty(true);
            this.setLayoutComputedFlexBasis(new YGFloatOptional());
            if (this.owner_ != null) {
                this.owner_.markDirtyAndPropogate();
            }
        }
    }

    public void markDirtyAndPropogateDownwards() {
        GlobalMembers.setBooleanData(this.flags, 2, true);
        this.children_.forEach(YGNode::markDirtyAndPropogateDownwards);
    }

    public float resolveFlexGrow() {
        if (this.owner_ == null) {
            return 0.0f;
        }
        if (!this.style_.flexGrow().isUndefined()) {
            return this.style_.flexGrow().unwrap();
        }
        if (!this.style_.flex().isUndefined() && this.style_.flex().unwrap() > 0.0f) {
            return this.style_.flex().unwrap();
        }
        return 0.0f;
    }

    public float resolveFlexShrink() {
        if (this.owner_ == null) {
            return 0.0f;
        }
        if (!this.style_.flexShrink().isUndefined()) {
            return this.style_.flexShrink().unwrap();
        }
        if (!GlobalMembers.getBooleanData(this.flags, 7) && !this.style_.flex().isUndefined() && this.style_.flex().unwrap() < 0.0f) {
            return -this.style_.flex().unwrap();
        }
        return GlobalMembers.getBooleanData(this.flags, 7) ? 1.0f : 0.0f;
    }

    public boolean isNodeFlexible() {
        return this.style_.positionType() != YGPositionType.YGPositionTypeAbsolute && (this.resolveFlexGrow() != 0.0f || this.resolveFlexShrink() != 0.0f);
    }

    public float getLeadingBorder(YGFlexDirection axis) {
        YGValue leadingBorder = (io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFlexDirectionIsRow(axis) ? YGNode.computeEdgeValueForRow(this.style_.border(), YGEdge.YGEdgeStart, io.github.orioncraftmc.meditate.internal.GlobalMembers.leading.get(axis.getValue()), CompactValue.ofZero()) : YGNode.computeEdgeValueForColumn(this.style_.border(), io.github.orioncraftmc.meditate.internal.GlobalMembers.leading.get(axis.getValue()), CompactValue.ofZero())).convertToYgValue();
        return Math.max(leadingBorder.value, 0.0f);
    }

    public float getTrailingBorder(YGFlexDirection axis) {
        YGValue trailingBorder = (io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFlexDirectionIsRow(axis) ? YGNode.computeEdgeValueForRow(this.style_.border(), YGEdge.YGEdgeEnd, io.github.orioncraftmc.meditate.internal.GlobalMembers.trailing.get(axis.getValue()), CompactValue.ofZero()) : YGNode.computeEdgeValueForColumn(this.style_.border(), io.github.orioncraftmc.meditate.internal.GlobalMembers.trailing.get(axis.getValue()), CompactValue.ofZero())).convertToYgValue();
        return Math.max(trailingBorder.value, 0.0f);
    }

    public YGFloatOptional getLeadingPadding(YGFlexDirection axis, float widthSize) {
        CompactValue leadingPadding = io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFlexDirectionIsRow(axis) ? YGNode.computeEdgeValueForRow(this.style_.padding(), YGEdge.YGEdgeStart, io.github.orioncraftmc.meditate.internal.GlobalMembers.leading.get(axis.getValue()), CompactValue.ofZero()) : YGNode.computeEdgeValueForColumn(this.style_.padding(), io.github.orioncraftmc.meditate.internal.GlobalMembers.leading.get(axis.getValue()), CompactValue.ofZero());
        return io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFloatOptionalMax(io.github.orioncraftmc.meditate.internal.GlobalMembers.YGResolveValue(leadingPadding, widthSize), new YGFloatOptional(0.0f));
    }

    public YGFloatOptional getTrailingPadding(YGFlexDirection axis, float widthSize) {
        CompactValue trailingPadding = io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFlexDirectionIsRow(axis) ? YGNode.computeEdgeValueForRow(this.style_.padding(), YGEdge.YGEdgeEnd, io.github.orioncraftmc.meditate.internal.GlobalMembers.trailing.get(axis.getValue()), CompactValue.ofZero()) : YGNode.computeEdgeValueForColumn(this.style_.padding(), io.github.orioncraftmc.meditate.internal.GlobalMembers.trailing.get(axis.getValue()), CompactValue.ofZero());
        return io.github.orioncraftmc.meditate.internal.GlobalMembers.YGFloatOptionalMax(io.github.orioncraftmc.meditate.internal.GlobalMembers.YGResolveValue(trailingPadding, widthSize), new YGFloatOptional(0.0f));
    }

    public YGFloatOptional getLeadingPaddingAndBorder(YGFlexDirection axis, float widthSize) {
        return io.github.orioncraftmc.meditate.internal.GlobalMembers.plus(this.getLeadingPadding(axis, widthSize), new YGFloatOptional(this.getLeadingBorder(axis)));
    }

    public YGFloatOptional getTrailingPaddingAndBorder(YGFlexDirection axis, float widthSize) {
        return io.github.orioncraftmc.meditate.internal.GlobalMembers.plus(this.getTrailingPadding(axis, widthSize), new YGFloatOptional(this.getTrailingBorder(axis)));
    }

    public boolean didUseLegacyFlag() {
        boolean didUseLegacyFlag = this.layout_.didUseLegacyFlag();
        if (didUseLegacyFlag) {
            return true;
        }
        for (YGNode child : this.children_) {
            if (!child.layout_.didUseLegacyFlag()) continue;
            didUseLegacyFlag = true;
            break;
        }
        return didUseLegacyFlag;
    }

    public void setLayoutDoesLegacyFlagAffectsLayout(boolean doesLegacyFlagAffectsLayout) {
        this.layout_.setDoesLegacyStretchFlagAffectsLayout(doesLegacyFlagAffectsLayout);
    }

    public void setLayoutDidUseLegacyFlag(boolean didUseLegacyFlag) {
        this.layout_.setDidUseLegacyFlag(didUseLegacyFlag);
    }

    public boolean isLayoutTreeEqualToNode(YGNode node) {
        YGNode otherNodeChildren;
        YGNode child;
        if (this.children_.size() != node.children_.size()) {
            return false;
        }
        if (this.layout_ != node.layout_) {
            return false;
        }
        if (this.children_.size() == 0) {
            return true;
        }
        boolean isLayoutTreeEqual = true;
        int children_size = this.children_.size();
        for (int i = 0; i < children_size && (isLayoutTreeEqual = (child = this.children_.get(i)).isLayoutTreeEqualToNode(otherNodeChildren = node.children_.get(i))); ++i) {
        }
        return isLayoutTreeEqual;
    }

    public void reset() {
        io.github.orioncraftmc.meditate.internal.GlobalMembers.YGAssertWithNode(this, this.children_.size() == 0, "Cannot reset a node which still has children attached");
        io.github.orioncraftmc.meditate.internal.GlobalMembers.YGAssertWithNode(this, this.owner_ == null, "Cannot reset a node still attached to a owner");
        this.clearChildren();
        boolean webDefaults = GlobalMembers.getBooleanData(this.flags, 7);
        this.config_ = new YGConfig(null);
        if (webDefaults) {
            this.useWebDefaults();
        }
    }

    public Object getContext() {
        return this.context_;
    }

    public void setContext(Object context_) {
        this.context_ = context_;
    }

    public Map<Object, Object> getFlags() {
        return this.flags;
    }

    public void setFlags(Map<Object, Object> flags) {
        this.flags = flags;
    }

    public byte getReserved() {
        return this.reserved_;
    }

    public void setReserved(byte reserved_) {
        this.reserved_ = reserved_;
    }

    public measure_Struct getMeasure() {
        return this.measure_;
    }

    public void setMeasure(measure_Struct measure_) {
        this.measure_ = measure_;
    }

    public baseline_Struct getBaseline() {
        return this.baseline_;
    }

    public void setBaseline(baseline_Struct baseline_) {
        this.baseline_ = baseline_;
    }

    public print_Struct getPrint() {
        return this.print_;
    }

    public void setPrint(print_Struct print_) {
        this.print_ = print_;
    }

    public YGDirtiedFunc getDirtied() {
        return this.dirtied_;
    }

    public void setDirtied(YGDirtiedFunc dirtied_) {
        this.dirtied_ = dirtied_;
    }

    public YGStyle getStyle() {
        return this.style_;
    }

    public void setStyle(YGStyle style_) {
        this.style_ = style_;
    }

    public YGLayout getLayout() {
        return this.layout_;
    }

    public void setLayout(YGLayout layout_) {
        if (layout_ == null) {
            layout_ = new YGLayout();
        }
        this.layout_ = layout_;
    }

    public int getLineIndex() {
        return this.lineIndex_;
    }

    public void setLineIndex(int lineIndex_) {
        this.lineIndex_ = lineIndex_;
    }

    public YGNode getOwner() {
        return this.owner_;
    }

    public void setOwner(YGNode owner_) {
        this.owner_ = owner_;
    }

    public ArrayList<YGNode> getChildren() {
        return this.children_;
    }

    public void setChildren(ArrayList<YGNode> children_) {
        this.children_ = children_;
    }

    public YGConfig getConfig() {
        return this.config_;
    }

    public void setConfig(YGConfig config_) {
        this.config_ = config_;
    }

    public ArrayList<YGValue> getResolvedDimensions() {
        return this.resolvedDimensions_;
    }

    public void setResolvedDimensions(ArrayList<YGValue> resolvedDimensions_) {
        this.resolvedDimensions_ = resolvedDimensions_;
    }

    public static class print_Struct {
        public YGPrintFunc noContext = null;
        public PrintWithContextFn withContext;
    }

    public static class baseline_Struct {
        public YGBaselineFunc noContext = null;
        public BaselineWithContextFn withContext;
    }

    public static class measure_Struct {
        public YGMeasureFunc noContext = null;
        public MeasureWithContextFn withContext;
    }
}

