/*
 * Decompiled with CFR 0.152.
 */
package io.github.orioncraftmc.meditate.internal.detail;

import io.github.orioncraftmc.meditate.internal.YGValue;
import io.github.orioncraftmc.meditate.internal.enums.YGUnit;

public class CompactValue {
    public static final float LOWER_BOUND = 1.0842022E-19f;
    public static final float UPPER_BOUND_POINT = 3.6893486E19f;
    public static final float UPPER_BOUND_PERCENT = 1.8446743E19f;
    private final Payload payload_;
    private boolean undefined;

    public CompactValue() {
        this.undefined = true;
        this.payload_ = new Payload(Float.NaN, YGUnit.YGUnitUndefined);
    }

    private CompactValue(Payload data) {
        this.payload_ = data;
    }

    public static CompactValue of(float value, YGUnit Unit) {
        float upperBound;
        if (value < 1.0842022E-19f && value > -1.0842022E-19f) {
            return new CompactValue(new Payload(0.0f, Unit));
        }
        float f = upperBound = Unit == YGUnit.YGUnitPercent ? 1.8446743E19f : 3.6893486E19f;
        if (value > upperBound || value < -upperBound) {
            value = Math.copySign(upperBound, value);
        }
        Payload data = new Payload(value, Unit);
        return new CompactValue(data);
    }

    public static CompactValue ofMaybe(float value, YGUnit Unit) {
        return Float.isNaN(value) || Float.isInfinite(value) ? CompactValue.ofUndefined() : CompactValue.of(value, Unit);
    }

    public static CompactValue ofZero() {
        return new CompactValue(new Payload(0.0f, YGUnit.YGUnitPoint));
    }

    public static CompactValue ofUndefined() {
        return new CompactValue();
    }

    public static CompactValue ofAuto() {
        return new CompactValue(new Payload(0.0f, YGUnit.YGUnitAuto));
    }

    public static CompactValue createCompactValue(YGValue x) {
        CompactValue compactValue;
        switch (x.unit) {
            case YGUnitUndefined: {
                compactValue = CompactValue.ofUndefined();
                break;
            }
            case YGUnitAuto: {
                compactValue = CompactValue.ofAuto();
                break;
            }
            case YGUnitPoint: {
                compactValue = CompactValue.of(x.value, YGUnit.YGUnitPoint);
                break;
            }
            case YGUnitPercent: {
                compactValue = CompactValue.of(x.value, YGUnit.YGUnitPercent);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return compactValue;
    }

    public static boolean equalsTo(CompactValue a, CompactValue b) {
        return a.payload_.unit.equals((Object)b.payload_.unit) && a.payload_.value == b.payload_.value;
    }

    public YGValue convertToYgValue() {
        return new YGValue(this.payload_.value, this.payload_.unit);
    }

    public final boolean isUndefined() {
        return this.undefined || !this.isAuto() && !this.isPoint() && !this.isPercent() && Float.isNaN(this.payload_.value);
    }

    private boolean isPercent() {
        return this.payload_.unit.equals((Object)YGUnit.YGUnitPercent);
    }

    private boolean isPoint() {
        return this.payload_.unit.equals((Object)YGUnit.YGUnitPoint);
    }

    public final boolean isAuto() {
        return this.payload_.unit.equals((Object)YGUnit.YGUnitAuto);
    }

    private YGUnit repr() {
        return this.payload_.unit;
    }

    private static class Payload {
        public final float value;
        public final YGUnit unit;

        public Payload(float value, YGUnit unit) {
            this.value = value;
            this.unit = unit;
        }
    }
}

