/*
 * Decompiled with CFR 0.152.
 */
package io.github.orioncraftmc.meditate.internal.event;

import io.github.orioncraftmc.meditate.internal.YGNode;
import io.github.orioncraftmc.meditate.internal.event.CallableEvent;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Consumer;

public class Event {
    private static final HashMap<Class<?>, Collection<Consumer<CallableEvent>>> listeners = new HashMap();

    public static void reset() {
        listeners.clear();
    }

    public static <T extends CallableEvent> void subscribe(Class<T> clazz, Consumer<T> listener) {
        listeners.computeIfAbsent(clazz, aClass -> new ArrayDeque()).add(listener);
    }

    public static void publish(YGNode node) {
        Event.publish(node, new EmptyEventData());
    }

    public static void publish(YGNode node, CallableEvent eventData) {
        Collection<Consumer<CallableEvent>> listeners = Event.listeners.get(eventData.getClass());
        if (listeners != null) {
            for (Consumer<CallableEvent> listener : listeners) {
                listener.accept(eventData);
            }
        }
    }

    private static void publish(YGNode node, Type eventType, CallableEvent eventData) {
        Event.publish(node, eventData);
    }

    public static class EmptyEventData
    extends CallableEvent {
    }

    public static enum Type {
        NodeAllocation,
        NodeDeallocation,
        NodeLayout,
        LayoutPassStart,
        LayoutPassEnd,
        MeasureCallbackStart,
        MeasureCallbackEnd,
        NodeBaselineStart,
        NodeBaselineEnd;

        public static final int SIZE = 32;

        public static Type forValue(int value) {
            return Type.values()[value];
        }

        public int getValue() {
            return this.ordinal();
        }
    }
}

